/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.tropicraft.core.common.sound.Sounds;

public enum RecordMusic {
    BURIED_TREASURE((Supplier<SoundEvent>)Sounds.BURIED_TREASURE, "Punchaface", "https://www.youtube.com/watch?v=lPhHWYnUR_4", 362),
    EASTERN_ISLES((Supplier<SoundEvent>)Sounds.EASTERN_ISLES, "Frox", "https://soundcloud.com/froxlab/eastern_isles", 376),
    THE_TRIBE((Supplier<SoundEvent>)Sounds.THE_TRIBE, "Emile Van Krieken", "https://www.youtube.com/watch?v=LvxVDhMvwE4", 154),
    LOW_TIDE((Supplier<SoundEvent>)Sounds.LOW_TIDE, "Punchaface", "https://youtu.be/VgB2TjwGOuQ", 347),
    TRADE_WINDS((Supplier<SoundEvent>)Sounds.TRADE_WINDS, "Frox", "https://soundcloud.com/froxlab/breakset-37-unnamed", 240),
    SUMMERING((Supplier<SoundEvent>)Sounds.SUMMERING, "Billy Christiansen", "https://www.youtube.com/watch?v=szO30RmM7b8", 292);

    public final String name = RegistrateLangProvider.toEnglishName((String)this.name());
    private final Supplier<SoundEvent> sound;
    public final String author;
    public final String url;
    private final int lengthInSeconds;

    private RecordMusic(Supplier<SoundEvent> sound, String author, String url, int lengthInSeconds) {
        this.sound = sound;
        this.author = author;
        this.url = url;
        this.lengthInSeconds = lengthInSeconds;
    }

    public SoundEvent getSound() {
        return this.sound.get();
    }

    public List<String> getTooltip() {
        return Arrays.asList(this.author + " - " + this.name, this.url);
    }

    public int lengthInTicks() {
        return this.lengthInSeconds * 20;
    }
}

