/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TropicraftSpawnEgg<T extends Entity>
extends Item {
    private final RegistryEntry<EntityType<T>> typeIn;

    public TropicraftSpawnEgg(RegistryEntry<EntityType<T>> type, Item.Properties properties) {
        super(properties);
        this.typeIn = type;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity te;
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Direction dir = context.m_43719_();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block == Blocks.f_50085_ && (te = world.m_7702_(pos)) instanceof SpawnerBlockEntity) {
            BaseSpawner spawner = ((SpawnerBlockEntity)te).m_59801_();
            EntityType spawnType = (EntityType)this.typeIn.get();
            spawner.m_45462_(spawnType);
            te.m_6596_();
            world.m_7260_(pos, state, state, 3);
            itemStack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        BlockPos spawnPos = state.m_60812_((BlockGetter)world, pos).m_83281_() ? pos : pos.m_121945_(dir);
        EntityType type3 = (EntityType)this.typeIn.get();
        if (type3.m_20592_((ServerLevel)world, itemStack, context.m_43723_(), spawnPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(pos, spawnPos) && dir == Direction.UP) != null) {
            itemStack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.m_21120_(hand);
        if (world.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)heldItem);
        }
        BlockHitResult rayTraceResult = TropicraftSpawnEgg.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)heldItem);
        }
        BlockHitResult traceResult = rayTraceResult;
        BlockPos tracePos = traceResult.m_82425_();
        if (!(world.m_8055_(tracePos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)heldItem);
        }
        if (world.m_7966_(player, tracePos) && player.m_36204_(tracePos, traceResult.m_82434_(), heldItem)) {
            EntityType type = (EntityType)this.typeIn.get();
            if (type.m_20592_((ServerLevel)world, heldItem, player, tracePos, MobSpawnType.SPAWN_EGG, false, false) == null) {
                return InteractionResultHolder.m_19098_((Object)heldItem);
            }
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return InteractionResultHolder.m_19100_((Object)heldItem);
    }
}

