/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.tropicraft.core.client.scuba.ModelScubaGear;
import net.tropicraft.core.common.item.ArmorMaterials;
import net.tropicraft.core.common.item.TropicraftArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaGogglesItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

public class ScubaArmorItem
extends TropicraftArmorItem {
    private static final ResourceLocation GOGGLES_OVERLAY_TEX_PATH = new ResourceLocation("tropicraft", "textures/gui/goggles.png");
    private final ScubaType type;

    public ScubaArmorItem(ScubaType type, EquipmentSlot slotType, Item.Properties properties) {
        super(ArmorMaterials.SCUBA, slotType, properties);
        this.type = type;
    }

    public ScubaType getType() {
        return this.type;
    }

    public boolean providesAir() {
        return false;
    }

    public void tickAir(Player player, EquipmentSlot slot, ItemStack stack) {
    }

    public int addAir(int air, ItemStack stack) {
        return 0;
    }

    public int getRemainingAir(ItemStack stack) {
        return 0;
    }

    public int getMaxAir(ItemStack stack) {
        return 0;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ScubaArmorItem.getArmorTexture(this.type).toString();
    }

    public static ResourceLocation getArmorTexture(ScubaType material) {
        return new ResourceLocation("tropicraft:textures/models/armor/scuba_gear_" + material.getTextureName() + ".png");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (stack.m_41619_()) {
                    return null;
                }
                HumanoidModel<?> armorModel = this.getArmorModel(slot);
                if (armorModel != null) {
                    this.prepareModel(armorModel, entity);
                    return armorModel;
                }
                return null;
            }

            @Nullable
            private HumanoidModel<?> getArmorModel(EquipmentSlot armorSlot) {
                return switch (armorSlot) {
                    case EquipmentSlot.HEAD -> ModelScubaGear.HEAD;
                    case EquipmentSlot.CHEST -> ModelScubaGear.CHEST;
                    case EquipmentSlot.FEET -> ModelScubaGear.FEET;
                    default -> null;
                };
            }

            private <E extends LivingEntity> void prepareModel(HumanoidModel<E> armorModel, LivingEntity entity) {
                armorModel.m_6839_(entity, 0.0f, 0.0f, 1.0f);
                armorModel.f_102817_ = entity.m_6144_();
                armorModel.f_102610_ = entity.m_6162_();
                armorModel.f_102816_ = entity.m_21205_() != null ? HumanoidModel.ArmPose.BLOCK : HumanoidModel.ArmPose.EMPTY;
            }

            public void renderHelmetOverlay(ItemStack stack, Player player, int width, int height, float partialTicks) {
                if (stack.m_41720_() instanceof ScubaGogglesItem) {
                    RenderSystem.m_69465_();
                    RenderSystem.m_69458_((boolean)false);
                    RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft mc = Minecraft.m_91087_();
                    double scaledWidth = mc.m_91268_().m_85445_();
                    double scaledHeight = mc.m_91268_().m_85446_();
                    RenderSystem.m_157456_((int)0, (ResourceLocation)GOGGLES_OVERLAY_TEX_PATH);
                    Tesselator tesselator = Tesselator.m_85913_();
                    BufferBuilder builder = tesselator.m_85915_();
                    builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    builder.m_5483_(0.0, scaledHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
                    builder.m_5483_(scaledWidth, scaledHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
                    builder.m_5483_(scaledWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
                    builder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
                    tesselator.m_85914_();
                    RenderSystem.m_69458_((boolean)true);
                    RenderSystem.m_69482_();
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        });
    }
}

