/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.network.TropicraftPackets;
import net.tropicraft.core.common.network.message.MessageUpdateScubaData;

@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScubaData
implements INBTSerializable<CompoundTag> {
    public static final Capability<ScubaData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ScubaData>(){

        public String toString() {
            return super.toString();
        }
    });
    private static final Set<ServerPlayer> underwaterPlayers = Collections.newSetFromMap(new WeakHashMap());
    private long diveTime;
    private double maxDepth;
    private boolean dirty;

    @SubscribeEvent
    public static void onCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("tropicraft", "scuba_data"), (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                LazyOptional<ScubaData> data = LazyOptional.of(ScubaData::new);

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CAPABILITY.orEmpty(cap, this.data);
                }

                public CompoundTag serializeNBT() {
                    return ((ScubaData)this.data.orElseThrow(IllegalStateException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    ((ScubaData)this.data.orElseThrow(IllegalStateException::new)).deserializeNBT(nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack chestStack;
        Item chestItem;
        Level world = event.player.f_19853_;
        if (event.phase == TickEvent.Phase.END && (chestItem = (chestStack = event.player.m_6844_(EquipmentSlot.CHEST)).m_41720_()) instanceof ScubaArmorItem) {
            LazyOptional data = event.player.getCapability(CAPABILITY);
            if (!world.f_46443_) {
                underwaterPlayers.add((ServerPlayer)event.player);
            }
            if (ScubaData.isUnderWater(event.player)) {
                data.ifPresent(d -> {
                    d.tick(event.player);
                    if (!world.f_46443_) {
                        d.updateClient((ServerPlayer)event.player, false);
                    }
                });
                ((ScubaArmorItem)chestItem).tickAir(event.player, EquipmentSlot.CHEST, chestStack);
                if (!world.f_46443_ && world.m_46467_() % 60L == 0L) {
                    Vec3 eyePos = event.player.m_20299_(0.0f);
                    Vec3 motion = event.player.m_20184_();
                    Vec3 particlePos = eyePos.m_82549_(motion.m_82548_());
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123795_, particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 4 + world.f_46441_.m_188503_(3), 0.25, 0.25, 0.25, motion.m_82553_());
                }
            } else if (!world.f_46443_ && underwaterPlayers.remove(event.player)) {
                data.ifPresent(d -> d.updateClient((ServerPlayer)event.player, false));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(CAPABILITY).ifPresent(d -> event.getEntity().getCapability(CAPABILITY).ifPresent(d2 -> d2.copyFrom((ScubaData)d)));
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ScubaData.updateClient((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        ScubaData.updateClient((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ScubaData.updateClient((PlayerEvent)event);
    }

    private static void updateClient(PlayerEvent event) {
        if (!event.getEntity().f_19853_.f_46443_) {
            event.getEntity().getCapability(CAPABILITY).ifPresent(d -> d.updateClient((ServerPlayer)event.getEntity(), true));
        }
    }

    public static boolean isUnderWater(Player player) {
        BlockPos headPos = new BlockPos(player.m_20299_(0.0f));
        return player.f_19853_.m_6425_(headPos).m_205070_(FluidTags.f_13131_);
    }

    public static double getDepth(Player player) {
        if (ScubaData.isUnderWater(player)) {
            int surface = TropicraftDimension.getSeaLevel((LevelReader)player.f_19853_);
            double depth = (double)surface - player.m_20299_(0.0f).m_7098_();
            return depth;
        }
        return 0.0;
    }

    void tick(Player player) {
        ++this.diveTime;
        if (player.f_19853_.m_46467_() % 100L == 0L) {
            this.dirty = true;
        }
        this.updateMaxDepth(ScubaData.getDepth(player));
    }

    public long getDiveTime() {
        return this.diveTime;
    }

    void updateMaxDepth(double depth) {
        if (depth > this.maxDepth) {
            this.maxDepth = depth;
        }
    }

    public double getMaxDepth() {
        return this.maxDepth;
    }

    void updateClient(ServerPlayer target, boolean force) {
        if (this.dirty || force) {
            TropicraftPackets.CHANNEL.send(PacketDistributor.PLAYER.with(() -> target), (Object)new MessageUpdateScubaData(this));
        }
    }

    public void copyFrom(ScubaData data) {
        this.diveTime = data.getDiveTime();
        this.maxDepth = data.getMaxDepth();
    }

    public CompoundTag serializeNBT() {
        CompoundTag ret = new CompoundTag();
        ret.m_128356_("diveTime", this.diveTime);
        ret.m_128347_("maxDepth", this.maxDepth);
        return ret;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.diveTime = nbt.m_128454_("diveTime");
        this.maxDepth = nbt.m_128459_("maxDepth");
    }

    public void serializeBuffer(FriendlyByteBuf buf) {
        buf.writeLong(this.diveTime);
        buf.writeDouble(this.maxDepth);
    }

    public void deserializeBuffer(FriendlyByteBuf buf) {
        this.diveTime = buf.readLong();
        this.maxDepth = buf.readDouble();
    }
}

