/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.rack;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.ItemHandlerWrapper;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.blocks.IToolProviderBlock;
import se.mickelus.tetra.blocks.TetraWaterloggedBlock;
import se.mickelus.tetra.blocks.rack.RackTESR;
import se.mickelus.tetra.blocks.rack.RackTile;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.properties.IToolProvider;
import se.mickelus.tetra.properties.PropertyHelper;

@ParametersAreNonnullByDefault
public class RackBlock
extends TetraWaterloggedBlock
implements EntityBlock,
IToolProviderBlock {
    public static final String identifier = "rack";
    public static final DirectionProperty facingProp = HorizontalDirectionalBlock.f_54117_;
    private static final Map<Direction, VoxelShape> shapes = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)14.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0)));
    @ObjectHolder(registryName="block", value="tetra:rack")
    public static RackBlock instance;

    public RackBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60978_(1.0f).m_60918_(SoundType.f_56736_));
    }

    private static double getHitX(Direction facing, AABB boundingBox, double hitX, double hitY, double hitZ) {
        switch (facing) {
            case NORTH: {
                return boundingBox.f_82291_ - hitX;
            }
            case SOUTH: {
                return hitX - boundingBox.f_82288_;
            }
            case WEST: {
                return hitZ - boundingBox.f_82290_;
            }
            case EAST: {
                return boundingBox.f_82293_ - hitZ;
            }
        }
        return 0.0;
    }

    @Override
    public void clientInit() {
        BlockEntityRenderers.m_173590_(RackTile.type, RackTESR::new);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{facingProp});
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction facing = (Direction)blockState.m_61143_((Property)facingProp);
        AABB boundingBox = blockState.m_60808_((BlockGetter)player.f_19853_, pos).m_83215_();
        if (facing == hit.m_82434_()) {
            Vec3 hitVec = hit.m_82450_();
            int slot = RackBlock.getHitX(facing, boundingBox, (float)hitVec.f_82479_ - (float)pos.m_123341_(), (float)hitVec.f_82480_ - (float)pos.m_123342_(), (float)hitVec.f_82481_ - (float)pos.m_123343_()) > 0.5 ? 1 : 0;
            TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, RackTile.class).ifPresent(tile -> tile.slotInteract(slot, player, hand));
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (Direction.Axis.Y != context.m_43719_().m_122434_()) {
            return Optional.of((BlockState)this.m_49966_().m_61124_((Property)facingProp, (Comparable)context.m_43719_())).filter(blockState -> blockState.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())).orElse(null);
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)facingProp)).m_122424_())).m_60767_().m_76333_();
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        RackBlock.dropBlockInventory(this, world, pos, newState);
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122424_() == stateIn.m_61143_((Property)facingProp) && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shapes.get(state.m_61143_((Property)facingProp));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)facingProp, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)facingProp)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)facingProp)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        if (Screen.m_96638_()) {
            tooltip.add(Tooltips.expanded);
            tooltip.add((Component)Component.m_237115_((String)"block.tetra.rack.description").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add(Tooltips.expand);
        }
    }

    @Override
    public boolean canProvideTools(Level world, BlockPos pos, BlockPos targetPos) {
        return true;
    }

    @Override
    public Collection<ToolAction> getTools(Level world, BlockPos pos, BlockState blockState) {
        return Optional.ofNullable(world.m_7702_(pos)).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).map(ItemHandlerWrapper::new).map(PropertyHelper::getInventoryTools).orElseGet(Collections::emptySet);
    }

    @Override
    public int getToolLevel(Level world, BlockPos pos, BlockState blockState, ToolAction toolAction) {
        return Optional.ofNullable(world.m_7702_(pos)).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).map(ItemHandlerWrapper::new).map(inv -> PropertyHelper.getInventoryToolLevel((Container)inv, toolAction)).orElse(-1);
    }

    @Override
    public ItemStack onCraftConsumeTool(Level world, BlockPos pos, BlockState blockState, ItemStack targetStack, String slot, boolean isReplacing, Player player, ToolAction requiredTool, int requiredLevel, boolean consumeResources) {
        Container inventory;
        ItemStack providerStack;
        Optional optional = Optional.ofNullable(world.m_7702_(pos)).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).map(ItemHandlerWrapper::new);
        if (optional.isPresent() && player != null && !(providerStack = PropertyHelper.getInventoryProvidingItemStack(inventory = (Container)optional.orElse(null), requiredTool, requiredLevel)).m_41619_()) {
            if (consumeResources) {
                this.spawnConsumeParticle(world, pos, blockState, inventory, providerStack);
            }
            return ((IToolProvider)providerStack.m_41720_()).onCraftConsume(providerStack, targetStack, player, requiredTool, requiredLevel, consumeResources);
        }
        return null;
    }

    @Override
    public ItemStack onActionConsumeTool(Level world, BlockPos pos, BlockState blockState, ItemStack targetStack, Player player, ToolAction requiredTool, int requiredLevel, boolean consumeResources) {
        Container inventory;
        ItemStack providerStack;
        Optional optional = Optional.ofNullable(world.m_7702_(pos)).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).map(ItemHandlerWrapper::new);
        if (optional.isPresent() && player != null && !(providerStack = PropertyHelper.getInventoryProvidingItemStack(inventory = (Container)optional.orElse(null), requiredTool, requiredLevel)).m_41619_()) {
            if (consumeResources) {
                this.spawnConsumeParticle(world, pos, blockState, inventory, providerStack);
            }
            return ((IToolProvider)providerStack.m_41720_()).onActionConsume(providerStack, targetStack, player, requiredTool, requiredLevel, consumeResources);
        }
        return null;
    }

    private void spawnConsumeParticle(Level world, BlockPos pos, BlockState blockState, Container inventory, ItemStack providerStack) {
        if (world instanceof ServerLevel) {
            Direction facing = (Direction)blockState.m_61143_((Property)facingProp);
            Vec3 particlePos = Vec3.m_82528_((Vec3i)pos).m_82520_(0.5, 0.75, 0.5).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.3));
            ItemStack firstSlot = inventory.m_8020_(0);
            particlePos = ItemStack.m_41728_((ItemStack)providerStack, (ItemStack)(firstSlot = Optional.of(ItemUpgradeRegistry.instance.getReplacement(firstSlot)).filter(itemStack -> !itemStack.m_41619_()).orElse(firstSlot))) ? particlePos.m_82549_(Vec3.m_82528_((Vec3i)facing.m_122428_().m_122436_()).m_82490_(-0.25)) : particlePos.m_82549_(Vec3.m_82528_((Vec3i)facing.m_122428_().m_122436_()).m_82490_(0.25));
            ((ServerLevel)world).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.66f, 0.66f), 1.0f), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 2, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new RackTile(p_153215_, p_153216_);
    }
}

