/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.getter;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

@ParametersAreNonnullByDefault
public class TooltipGetterBlockingDuration
implements ITooltipGetter {
    private final IStatGetter durationGetter;
    private final IStatGetter cooldownGetter;

    public TooltipGetterBlockingDuration(IStatGetter durationGetter, IStatGetter cooldownGetter) {
        this.durationGetter = durationGetter;
        this.cooldownGetter = cooldownGetter;
    }

    @Override
    public String getTooltipBase(Player player, ItemStack itemStack) {
        double cooldownMultiplier = this.cooldownGetter.getValue(player, itemStack);
        if (cooldownMultiplier > 0.0) {
            if (cooldownMultiplier != 1.0) {
                double baseCooldown = CastOptional.cast((Object)itemStack.m_41720_(), ItemModularHandheld.class).map(item -> item.getCooldownBase(itemStack)).orElse(1.0);
                return I18n.m_118938_((String)"tetra.stats.blocking_duration_cooldown.tooltip", (Object[])new Object[]{String.format("%.1f", this.durationGetter.getValue(player, itemStack)), String.format("%.2f", cooldownMultiplier), String.format("%.1f", cooldownMultiplier * baseCooldown)});
            }
            return I18n.m_118938_((String)"tetra.stats.blocking_duration.tooltip", (Object[])new Object[]{String.format("%.1f", this.durationGetter.getValue(player, itemStack))});
        }
        return I18n.m_118938_((String)"tetra.stats.blocking.tooltip", (Object[])new Object[0]);
    }

    @Override
    public boolean hasExtendedTooltip(Player player, ItemStack itemStack) {
        return true;
    }

    @Override
    public String getTooltipExtension(Player player, ItemStack itemStack) {
        return I18n.m_118938_((String)"tetra.stats.blocking.tooltip_extended", (Object[])new Object[0]);
    }
}

