/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.data.ImprovementData;

@ParametersAreNonnullByDefault
public class ItemPredicateModular
extends ItemPredicate {
    private final Map<String, String> variants = new HashMap<String, String>();
    private final Map<String, Integer> improvements = new HashMap<String, Integer>();
    private String[][] modules = new String[0][0];

    public ItemPredicateModular(String[][] modules) {
        this.modules = modules;
    }

    public ItemPredicateModular(JsonObject jsonObject) {
        if (jsonObject.has("modules")) {
            JsonArray outerModules = jsonObject.getAsJsonArray("modules");
            this.modules = new String[outerModules.size()][];
            for (int i = 0; i < outerModules.size(); ++i) {
                JsonArray innerModules = outerModules.get(i).getAsJsonArray();
                this.modules[i] = new String[innerModules.size()];
                for (int j = 0; j < innerModules.size(); ++j) {
                    this.modules[i][j] = innerModules.get(j).getAsString();
                }
            }
        }
        if (jsonObject.has("variants")) {
            jsonObject.getAsJsonObject("variants").entrySet().forEach(entry -> this.variants.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
        }
        if (jsonObject.has("improvements")) {
            jsonObject.getAsJsonObject("improvements").entrySet().forEach(entry -> this.improvements.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt()));
        }
    }

    public boolean test(ItemStack itemStack, String slot) {
        if (!itemStack.m_41619_() && itemStack.m_41720_() instanceof IModularItem) {
            if (this.modules.length > 0 && !this.hasAnyModule(itemStack, slot)) {
                return false;
            }
            if (!this.variants.isEmpty() && !this.hasAnyVariant(itemStack, slot)) {
                return false;
            }
            return this.improvements.isEmpty() || this.checkImprovements(itemStack, slot);
        }
        return true;
    }

    private boolean hasAnyModule(ItemStack itemStack, String slot) {
        block5: {
            IModularItem item;
            block4: {
                item = (IModularItem)itemStack.m_41720_();
                if (slot == null) break block4;
                ItemModule module = item.getModuleFromSlot(itemStack, slot);
                if (module == null) break block5;
                for (String[] outer : this.modules) {
                    if (outer.length != 1 || !outer[0].equals(module.getKey())) continue;
                    return true;
                }
                break block5;
            }
            Collection<ItemModule> itemModules = item.getAllModules(itemStack);
            for (String[] outer : this.modules) {
                for (int j = 0; j < outer.length; ++j) {
                    int matchCount = 0;
                    for (ItemModule module : itemModules) {
                        if (!module.getKey().equals(outer[j])) continue;
                        ++matchCount;
                        break;
                    }
                    if (matchCount != outer.length) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasAnyVariant(ItemStack itemStack, String slot) {
        IModularItem item = (IModularItem)itemStack.m_41720_();
        for (Map.Entry<String, String> variant : this.variants.entrySet()) {
            ItemModule module;
            String currentSlot = variant.getValue();
            if (slot != null && "#slot".equals(currentSlot)) {
                currentSlot = slot;
            }
            if ((module = item.getModuleFromSlot(itemStack, currentSlot)) == null || !variant.getKey().equals(module.getVariantData((ItemStack)itemStack).key)) continue;
            return true;
        }
        return false;
    }

    private boolean checkImprovements(ItemStack itemStack, String slot) {
        IModularItem item = (IModularItem)itemStack.m_41720_();
        if (slot != null) {
            return CastOptional.cast((Object)item.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class).map(module -> {
                if (this.hasDisallowedImprovements((ItemModuleMajor)module, itemStack)) {
                    return false;
                }
                if (this.improvements.entrySet().stream().allMatch(entry -> ((String)entry.getKey()).startsWith("!"))) {
                    return true;
                }
                return this.hasImprovements((ItemModuleMajor)module, itemStack);
            }).orElse(false);
        }
        boolean hasDisallowed = Arrays.stream(item.getMajorModules(itemStack)).filter(Objects::nonNull).anyMatch(module -> this.hasDisallowedImprovements((ItemModuleMajor)module, itemStack));
        if (hasDisallowed) {
            return false;
        }
        if (this.improvements.entrySet().stream().allMatch(entry -> ((String)entry.getKey()).startsWith("!"))) {
            return true;
        }
        return Arrays.stream(item.getMajorModules(itemStack)).filter(Objects::nonNull).anyMatch(module -> this.hasImprovements((ItemModuleMajor)module, itemStack));
    }

    private boolean hasDisallowedImprovements(ItemModuleMajor module, ItemStack itemStack) {
        ImprovementData[] improvementData = module.getImprovements(itemStack);
        return this.improvements.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("!")).anyMatch(entry -> {
            for (ImprovementData data : improvementData) {
                if (!((String)entry.getKey()).substring(1).equals(data.key) || (Integer)entry.getValue() != -1 && (Integer)entry.getValue() != data.level) continue;
                return true;
            }
            return false;
        });
    }

    private boolean hasImprovements(ItemModuleMajor module, ItemStack itemStack) {
        ImprovementData[] improvementData = module.getImprovements(itemStack);
        return this.improvements.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("!")).anyMatch(entry -> {
            for (ImprovementData data : improvementData) {
                if (!((String)entry.getKey()).equals(data.key) || (Integer)entry.getValue() != -1 && (Integer)entry.getValue() != data.level) continue;
                return true;
            }
            return false;
        });
    }

    public boolean m_45049_(ItemStack itemStack) {
        return this.test(itemStack, null);
    }
}

