/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.shield;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.model.geom.builders.UVPair;

public class ShieldModelData {
    public static final Codec<UVPair> uvCodec = Codec.FLOAT.listOf().comapFlatMap(list -> Util.m_143795_((List)list, (int)2).map(l -> new UVPair(((Float)l.get(0)).floatValue(), ((Float)l.get(1)).floatValue())), pair -> ImmutableList.of((Object)Float.valueOf(pair.m_171612_()), (Object)Float.valueOf(pair.m_171613_())));
    private static final Codec<Part> partCodec = RecordCodecBuilder.create(instance -> instance.group((App)Vector3f.f_176762_.optionalFieldOf("origin", (Object)Vector3f.f_176763_).forGetter(i -> i.origin), (App)Vector3f.f_176762_.optionalFieldOf("dimensions", (Object)Vector3f.f_176763_).forGetter(i -> i.dimensions), (App)Vector3f.f_176762_.optionalFieldOf("rotation", (Object)Vector3f.f_176763_).forGetter(i -> i.rotation), (App)uvCodec.optionalFieldOf("uv", (Object)new UVPair(0.0f, 0.0f)).forGetter(i -> i.uv)).apply((Applicative)instance, Part::new));
    public static final Codec<ShieldModelData> codec = RecordCodecBuilder.create(instance -> instance.group((App)partCodec.listOf().fieldOf("parts").forGetter(i -> i.parts)).apply((Applicative)instance, ShieldModelData::new));
    List<Part> parts;

    public ShieldModelData(List<Part> parts) {
        this.parts = parts;
    }

    public void populatePartDefinition(PartDefinition partDefinition) {
        for (int i = 0; i < this.parts.size(); ++i) {
            Part part = this.parts.get(i);
            partDefinition.m_171599_("" + i, CubeListBuilder.m_171558_().m_171514_((int)part.uv.m_171612_(), (int)part.uv.m_171613_()).m_171481_(part.origin.m_122239_(), part.origin.m_122260_(), part.origin.m_122269_(), part.dimensions.m_122239_(), part.dimensions.m_122260_(), part.dimensions.m_122269_()), PartPose.m_171430_((float)((float)Math.toRadians(part.rotation.m_122239_())), (float)((float)Math.toRadians(part.rotation.m_122260_())), (float)((float)Math.toRadians(part.rotation.m_122269_()))));
        }
    }

    static class Part {
        Vector3f origin;
        Vector3f dimensions;
        Vector3f rotation;
        UVPair uv;

        public Part(Vector3f origin, Vector3f dimensions, Vector3f rotation, UVPair uv) {
            this.origin = origin;
            this.dimensions = dimensions;
            this.rotation = rotation;
            this.uv = uv;
        }
    }
}

