/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.mutil.gui.DisabledSlot;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.PotionSlot;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.PotionsInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.PredicateSlot;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuiverInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.StorageInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltInventory;

@ParametersAreNonnullByDefault
public class ToolbeltContainer
extends AbstractContainerMenu {
    public static RegistryObject<MenuType<ToolbeltContainer>> type;
    private final ItemStack itemStackToolbelt;
    private final QuickslotInventory quickslotInventory;
    private final StorageInventory storageInventory;
    private final PotionsInventory potionsInventory;
    private final QuiverInventory quiverInventory;

    public ToolbeltContainer(int windowId, Container playerInventory, ItemStack itemStackToolbelt, Player player) {
        super((MenuType)type.get(), windowId);
        int i;
        this.quickslotInventory = new QuickslotInventory(itemStackToolbelt);
        this.storageInventory = new StorageInventory(itemStackToolbelt);
        this.potionsInventory = new PotionsInventory(itemStackToolbelt);
        this.quiverInventory = new QuiverInventory(itemStackToolbelt);
        this.itemStackToolbelt = itemStackToolbelt;
        int numPotionSlots = this.potionsInventory.m_6643_();
        int numQuickslots = this.quickslotInventory.m_6643_();
        int numStorageSlots = this.storageInventory.m_6643_();
        int numQuiverSlots = this.quiverInventory.m_6643_();
        int offset = 0;
        if (numStorageSlots > 0) {
            int cols = Math.min(numStorageSlots, StorageInventory.getColumns(numStorageSlots));
            int rows = 1 + (numStorageSlots - 1) / cols;
            for (int i2 = 0; i2 < numStorageSlots; ++i2) {
                this.m_38897_(new PredicateSlot(this.storageInventory, i2, (int)(-8.5 * (double)cols + (double)(17 * (i2 % cols)) + 90.0), 108 - offset - i2 / cols * 17, this.storageInventory::isItemValid));
            }
            offset += rows * 17 + 13;
        }
        for (i = 0; i < numQuiverSlots; ++i) {
            this.m_38897_(new PredicateSlot(this.quiverInventory, i, (int)(-8.5 * (double)numQuiverSlots + (double)(17 * i) + 90.0), 108 - offset, this.quiverInventory::isItemValid));
        }
        if (numQuiverSlots > 0) {
            offset += 30;
        }
        for (i = 0; i < numPotionSlots; ++i) {
            this.m_38897_(new PotionSlot(this.potionsInventory, i, (int)(-8.5 * (double)numPotionSlots + (double)(17 * i) + 90.0), 108 - offset));
        }
        if (numPotionSlots > 0) {
            offset += 30;
        }
        for (i = 0; i < numQuickslots; ++i) {
            this.m_38897_(new PredicateSlot(this.quickslotInventory, i, (int)(-8.5 * (double)numQuickslots + (double)(17 * i) + 90.0), 108 - offset, this.quickslotInventory::isItemValid));
        }
        if (numQuickslots > 0) {
            offset += 30;
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                Object slot = itemStackToolbelt.m_41656_(playerInventory.m_8020_(i * 9 + j + 9)) ? new DisabledSlot(playerInventory, i * 9 + j + 9, j * 17 + 12, i * 17 + 142) : new Slot(playerInventory, i * 9 + j + 9, j * 17 + 12, i * 17 + 142);
                this.m_38897_((Slot)slot);
            }
        }
        for (i = 0; i < 9; ++i) {
            Object slot = itemStackToolbelt.m_41726_(playerInventory.m_8020_(i)) ? new DisabledSlot(playerInventory, i, i * 17 + 12, 197) : new Slot(playerInventory, i, i * 17 + 12, 197);
            this.m_38897_((Slot)slot);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ToolbeltContainer create(int windowId, Inventory inv) {
        ItemStack itemStack = inv.f_35978_.m_21205_();
        if (!((ModularToolbeltItem)ModularToolbeltItem.instance.get()).equals(itemStack.m_41720_())) {
            itemStack = inv.f_35978_.m_21206_();
        }
        if (!((ModularToolbeltItem)ModularToolbeltItem.instance.get()).equals(itemStack.m_41720_())) {
            itemStack = ToolbeltHelper.findToolbelt(inv.f_35978_);
        }
        return new ToolbeltContainer(windowId, (Container)inv, itemStack, inv.f_35978_);
    }

    private boolean mergeItemStackExtended(ItemStack incomingStack, int startIndex, int endIndex) {
        ItemStack slotStack;
        Slot slot;
        int i;
        for (i = startIndex; i < endIndex; ++i) {
            slot = (Slot)this.f_38839_.get(i);
            if (!slot.m_5857_(incomingStack) || !ItemStack.m_41746_((ItemStack)(slotStack = slot.m_7993_()), (ItemStack)incomingStack) || !ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)incomingStack)) continue;
            if (slotStack.m_41613_() + incomingStack.m_41613_() < slot.m_5866_(slotStack)) {
                slotStack.m_41769_(incomingStack.m_41613_());
                incomingStack.m_41764_(0);
                slot.m_6654_();
                return true;
            }
            int mergeCount = slot.m_5866_(slotStack) - slotStack.m_41613_();
            slotStack.m_41769_(mergeCount);
            incomingStack.m_41774_(mergeCount);
            slot.m_6654_();
        }
        for (i = startIndex; i < endIndex; ++i) {
            slot = (Slot)this.f_38839_.get(i);
            if (!slot.m_5857_(incomingStack) || !(slotStack = slot.m_7993_()).m_41619_()) continue;
            slot.m_5852_(incomingStack.m_41620_(slot.m_5866_(slotStack)));
            if (!incomingStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null) return ItemStack.f_41583_;
        if (!slot.m_6657_()) return ItemStack.f_41583_;
        ItemStack itemStack = slot.m_7993_();
        if (itemStack.m_41656_(this.itemStackToolbelt)) {
            return ItemStack.f_41583_;
        }
        int numQuiverSlots = this.quiverInventory.m_6643_();
        int numPotionSlots = this.potionsInventory.m_6643_();
        int numQuickslots = this.quickslotInventory.m_6643_();
        int numStorageSlots = this.storageInventory.m_6643_();
        int playerInventoryStart = numQuickslots + numStorageSlots + numPotionSlots + numQuiverSlots;
        if (slot.f_40218_ instanceof ToolbeltInventory) {
            if (slot.f_40218_ == this.potionsInventory && slot.getSlotIndex() == index) {
                int count = slot.m_7993_().m_41613_();
                itemStack = slot.m_6201_(64);
                if (!this.m_38903_(itemStack, playerInventoryStart, this.f_38839_.size(), true)) {
                    itemStack.m_41764_(count);
                    slot.m_5852_(itemStack);
                    slot.m_6654_();
                    return ItemStack.f_41583_;
                }
            } else {
                ItemStack copy = itemStack.m_41777_();
                ItemStack breakoff = copy.m_41620_(itemStack.m_41741_());
                if (!this.m_38903_(breakoff, playerInventoryStart, this.f_38839_.size(), true)) {
                    slot.m_6654_();
                    return ItemStack.f_41583_;
                }
                if (!copy.m_41619_()) {
                    if (!breakoff.m_41619_()) {
                        copy.m_41769_(breakoff.m_41613_());
                    }
                    slot.m_5852_(copy);
                } else {
                    slot.m_5852_(breakoff);
                }
                slot.m_6654_();
                return breakoff;
            }
            slot.m_6654_();
            return itemStack;
        }
        if (numQuiverSlots > 0 && this.m_38903_(itemStack, numStorageSlots, numStorageSlots + numQuiverSlots, false)) {
            return itemStack;
        }
        if (numPotionSlots > 0 && this.mergeItemStackExtended(itemStack, numStorageSlots + numQuiverSlots, numStorageSlots + numQuiverSlots + numPotionSlots)) {
            return itemStack;
        }
        if (numQuickslots > 0 && this.m_38903_(itemStack, numStorageSlots + numQuiverSlots + numPotionSlots, playerInventoryStart, false)) {
            return itemStack;
        }
        if (numStorageSlots <= 0) return ItemStack.f_41583_;
        if (!this.m_38903_(itemStack, 0, numStorageSlots, false)) return ItemStack.f_41583_;
        return itemStack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.quickslotInventory.m_5785_(playerIn);
    }

    public QuickslotInventory getQuickslotInventory() {
        return this.quickslotInventory;
    }

    public StorageInventory getStorageInventory() {
        return this.storageInventory;
    }

    public PotionsInventory getPotionInventory() {
        return this.potionsInventory;
    }

    public QuiverInventory getQuiverInventory() {
        return this.quiverInventory;
    }
}

