/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui.overlay;

import java.util.Arrays;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiStringOutline;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.mutil.gui.impl.GuiVerticalLayoutGroup;
import se.mickelus.tetra.gui.GuiTextures;

public class HolosphereActionGui
extends GuiElement {
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation focusLabel;
    private final KeyframeAnimation blurLabel;
    GuiTexture backdrop;
    GuiTexture icon;
    Runnable performRunnable;

    public HolosphereActionGui(int x, int y, int u, int v, String label, Runnable perform) {
        super(x, y, 23, 23);
        this.performRunnable = perform;
        this.backdrop = new GuiTexture(0, 0, 23, 23, 54, 28, GuiTextures.toolbelt);
        this.addChild((GuiElement)this.backdrop);
        this.icon = new GuiTexture(0, 0, 23, 23, u, v, GuiTextures.toolbelt);
        this.addChild((GuiElement)this.icon);
        GuiVerticalLayoutGroup labelContainer = new GuiVerticalLayoutGroup(2, 1, 0, -1);
        Arrays.stream(label.split("\n")).map(l -> new GuiStringOutline(0, 0, l).setAttachment(GuiAttachment.topCenter)).forEach(arg_0 -> ((GuiElement)labelContainer).addChild(arg_0));
        labelContainer.setAttachment(GuiAttachment.middleCenter);
        labelContainer.setOpacity(0.0f);
        this.addChild((GuiElement)labelContainer);
        this.isVisible = false;
        this.showAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateY((float)(y + 2), (float)y), new Applier.Opacity(0.0f, 1.0f)}).withDelay((int)(Math.random() * 300.0));
        this.focusLabel = new KeyframeAnimation(80, (GuiElement)labelContainer).applyTo(new Applier[]{new Applier.TranslateY(-2.0f, 0.0f), new Applier.Opacity(1.0f)});
        this.blurLabel = new KeyframeAnimation(120, (GuiElement)labelContainer).applyTo(new Applier[]{new Applier.TranslateY(0.0f, 2.0f), new Applier.Opacity(0.0f)});
    }

    public void perform() {
        this.performRunnable.run();
    }

    protected void onShow() {
        this.showAnimation.start();
    }

    protected boolean onHide() {
        if (this.showAnimation.isActive()) {
            this.showAnimation.stop();
        }
        return true;
    }

    protected void onFocus() {
        this.backdrop.setColor(0xFFFFCC);
        this.icon.setColor(0x7F7F7F);
        this.blurLabel.stop();
        this.focusLabel.start();
    }

    protected void onBlur() {
        this.backdrop.setColor(0xFFFFFF);
        this.icon.setColor(0xFFFFFF);
        this.focusLabel.stop();
        this.blurLabel.start();
    }

    public void updateFocusState(int refX, int refY, int mouseX, int mouseY) {
        boolean gainFocus;
        float ox = (float)(mouseX - refX - this.x) - (float)this.width / 2.0f;
        float oy = (float)(mouseY - refY - this.y) - (float)this.height / 2.0f;
        boolean bl = gainFocus = Math.abs(ox + oy) <= (float)this.width / 2.0f + 1.0f && Math.abs(ox - oy) <= (float)this.width / 2.0f + 1.0f;
        if (gainFocus != this.hasFocus) {
            this.hasFocus = gainFocus;
            if (this.hasFocus) {
                this.onFocus();
            } else {
                this.onBlur();
            }
        }
    }
}

