/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.sdrp.config;

import com.google.gson.GsonBuilder;
import com.sunekaer.sdrp.SDRPCrossPlatform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import org.jetbrains.annotations.Nullable;

@Config(name="sdrp-common")
public class SDRPConfig
implements ConfigData {
    @Comment(value="Your Discord App ID")
    public long clientId = 608012526537408579L;
    @Comment(value="If you wish to disable Discord Rich Presence, set this to false.")
    public boolean enabled = true;
    @Comment(value="If set to false, it disables the build in screenEvent, which is used to tell when we are on the main menu.")
    public boolean screenEvent = true;
    @Comment(value="If set to false, it disables the build in clientJoinEvent, which is used to tell when the player is join a world and changing Dimension.")
    public boolean clientJoinEvent = true;

    public void validatePostLoad() {
        Path oldConfig = SDRPCrossPlatform.getConfigDirectory().resolve("sdrp.json");
        if (Files.exists(oldConfig, new LinkOption[0])) {
            try {
                this.migrateOldConfig(oldConfig);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void migrateOldConfig(Path oldConfig) throws IOException {
        OldConfigData oldConfigData = (OldConfigData)new GsonBuilder().create().fromJson(Files.readString(oldConfig), OldConfigData.class);
        this.clientId = Optional.ofNullable((Long)oldConfigData.clientId.value).orElse(0L);
        this.enabled = Optional.ofNullable((Boolean)oldConfigData.enabled.value).orElse(true);
        Files.delete(oldConfig);
    }

    public static class OldConfigData {
        public OldConfigEntry<Long> clientId;
        public OldConfigEntry<Boolean> enabled;
    }

    public static final class OldConfigEntry<T> {
        @Nullable
        private T value;
        private String comment;
    }
}

