/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.sdrp.discord;

import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.IPCListener;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.pipe.PipeStatus;
import com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import com.sunekaer.sdrp.SDRP;
import com.sunekaer.sdrp.discord.State;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RPClient.class);
    public static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadScheduledExecutor();
    private IPCClient client = null;
    private RichPresence currentState = null;
    public final ArrayBlockingQueue<RichPresence> stateUpdateQueue = new ArrayBlockingQueue(24);

    public RPClient() {
        if (!SDRP.config.enabled) {
            LOGGER.info("Preventing Simple Discord Rich Presence from starting as it's disabled");
            return;
        }
        LOGGER.info("Setting up discord client");
        EXECUTOR_SERVICE.submit(this::connectClient);
        EXECUTOR_SERVICE.scheduleAtFixedRate(this::processStateQueue, 0L, 5L, TimeUnit.SECONDS);
        EXECUTOR_SERVICE.scheduleAtFixedRate(this::maintainCorrectState, 1000L, 120000L, TimeUnit.MILLISECONDS);
    }

    private void connectClient() {
        if (this.client != null) {
            return;
        }
        this.client = new IPCClient(SDRP.config.clientId);
        this.client.setListener(new IPCListener(){

            public void onReady(IPCClient client) {
                LOGGER.info("Discord client ready");
                if (State.PRESETS.containsKey("loading")) {
                    RPClient.this.setState(State.PRESETS.get("loading").createPresence());
                }
            }
        });
        try {
            this.client.connect(new DiscordBuild[0]);
        }
        catch (NoDiscordClientException e) {
            LOGGER.error("Unable to connect to the discord client", (Throwable)e);
        }
    }

    private void processStateQueue() {
        if (this.client == null || this.client.getStatus() != PipeStatus.CONNECTED) {
            return;
        }
        if (this.stateUpdateQueue.isEmpty()) {
            return;
        }
        RichPresence state = this.stateUpdateQueue.poll();
        if (state == null) {
            return;
        }
        this.client.sendRichPresence(state);
    }

    private void maintainCorrectState() {
        if (this.currentState != null && this.client.getStatus() == PipeStatus.CONNECTED) {
            this.setState(this.currentState);
        }
    }

    public void setState(RichPresence context) {
        if (!SDRP.config.enabled) {
            return;
        }
        this.currentState = context;
        try {
            this.stateUpdateQueue.add(context);
        }
        catch (IllegalStateException exception) {
            LOGGER.warn("Attempted to add context to update queue, operation failed due to a full list, something is likely wrong here or the discord client isn't present");
        }
    }

    public RichPresence getCurrentState() {
        return this.currentState;
    }

    public IPCClient getClient() {
        return this.client;
    }
}

