/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.sdrp.integration.kubejs;

import com.sunekaer.sdrp.integration.kubejs.SDRPKubeJSWrapper;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

public class SDRPKubeJSIntegration
extends KubeJSPlugin {
    static EventGroup GROUP = EventGroup.of((String)"sdrp");
    static EventHandler DIMENSION_CHANGE = GROUP.client("dimension_change", () -> ClientDimensionChangeEvent.class);

    public static void setup() {
        EntityEvent.ADD.register(SDRPKubeJSIntegration::clientJoinEvent);
    }

    public void registerBindings(BindingsEvent event) {
        event.add("SDRP", SDRPKubeJSWrapper.class);
    }

    public void registerEvents() {
        GROUP.register();
    }

    private static EventResult clientJoinEvent(Entity entity, Level level) {
        if (!(entity instanceof Player)) {
            return EventResult.pass();
        }
        Player player = (Player)entity;
        if (!level.f_46443_) {
            return EventResult.pass();
        }
        DIMENSION_CHANGE.post((EventJS)new ClientDimensionChangeEvent(level.m_6042_(), player, level));
        return EventResult.pass();
    }

    public static class ClientDimensionChangeEvent
    extends EventJS {
        public DimensionType dimensionType;
        public Player player;
        public Level level;

        public ClientDimensionChangeEvent(DimensionType dimensionType, Player player, Level level) {
            this.dimensionType = dimensionType;
            this.player = player;
            this.level = level;
        }

        public void updateSDRPState(String message, String imageName, String imageKey) {
            SDRPKubeJSWrapper.setState(message, imageName, imageKey);
        }
    }
}

