/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.ClientUtils;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedItemFrameModel
extends FramedBlockModel {
    private static final int GLOWING_BRIGHTNESS = 5;
    private final Direction facing;
    private final boolean leather;
    private final boolean mapFrame;
    private final boolean glowing;
    private final float innerLength;
    private final float innerPos;
    private final float innerMin;
    private final float innerMax;
    private final float outerMin;
    private final float outerMax;

    private FramedItemFrameModel(BlockState state, BakedModel baseModel, boolean glowing) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        this.leather = (Boolean)state.m_61143_((Property)PropertyHolder.LEATHER);
        this.mapFrame = (Boolean)state.m_61143_((Property)PropertyHolder.MAP_FRAME);
        this.glowing = glowing;
        this.innerLength = this.mapFrame ? 0.9375f : 0.8125f;
        this.innerPos = this.mapFrame ? 0.0625f : 0.1875f;
        this.innerMin = this.mapFrame ? 0.0625f : 0.1875f;
        this.innerMax = this.mapFrame ? 0.9375f : 0.8125f;
        this.outerMin = this.mapFrame ? 0.0f : 0.125f;
        this.outerMax = this.mapFrame ? 1.0f : 0.875f;
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadFace = quad.m_111306_();
        if (Utils.isY(this.facing)) {
            this.makeVerticalFrame(quadMap, quad, quadFace);
        } else {
            this.makeHorizontalFrame(quadMap, quad, quadFace);
        }
    }

    private void makeVerticalFrame(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction quadFace) {
        if (quadFace == this.facing) {
            QuadModifier.full(quad).applyIf(Modifiers.cutTopBottom(this.outerMin, this.outerMin, this.outerMax, this.outerMax), !this.mapFrame).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).export(quadMap.get(quadFace));
        } else if (quadFace == this.facing.m_122424_()) {
            if (!this.leather && !this.mapFrame) {
                QuadModifier.full(quad).apply(Modifiers.cutTopBottom(this.innerMin, this.innerMin, this.innerMax, this.innerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.03125f)).export(quadMap.get(null));
            }
            if (!this.mapFrame || this.leather) {
                QuadModifier.full(quad).apply(Modifiers.cutTopBottom(this.outerMin, this.outerMin, this.innerMin, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.full(quad).apply(Modifiers.cutTopBottom(this.innerMax, this.outerMin, this.outerMax, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.full(quad).apply(Modifiers.cutTopBottom(this.innerMin, this.outerMin, this.innerMax, this.innerMin)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.full(quad).apply(Modifiers.cutTopBottom(this.innerMin, this.innerMax, this.innerMax, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
            }
            if (this.mapFrame && !this.leather) {
                QuadModifier.full(quad).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(quadFace));
            }
        } else {
            boolean down = this.facing == Direction.UP;
            QuadModifier.full(quad).apply(Modifiers.cutSideUpDown(down, 0.0625f)).applyIf(Modifiers.cutSideLeftRight(this.outerMax), !this.mapFrame).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).applyIf(Modifiers.setPosition(this.outerMax), !this.mapFrame).export(quadMap.get(null));
            if (!this.mapFrame) {
                QuadModifier.full(quad).apply(Modifiers.cutSideUpDown(!down, 0.96875f)).apply(Modifiers.cutSideUpDown(down, 0.0625f)).apply(Modifiers.cutSideLeftRight(this.innerLength)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(this.innerPos)).export(quadMap.get(null));
            }
        }
    }

    private void makeHorizontalFrame(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction quadFace) {
        if (quadFace == this.facing) {
            QuadModifier.full(quad).applyIf(Modifiers.cutSide(this.outerMin, this.outerMin, this.outerMax, this.outerMax), !this.mapFrame).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).export(quadMap.get(quadFace));
        } else if (quadFace == this.facing.m_122424_()) {
            if (!this.leather && !this.mapFrame) {
                QuadModifier.full(quad).apply(Modifiers.cutSide(this.innerMin, this.innerMin, this.innerMax, this.innerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.03125f)).export(quadMap.get(null));
            }
            if (!this.mapFrame || this.leather) {
                QuadModifier.full(quad).apply(Modifiers.cutSide(this.outerMin, this.outerMin, this.innerMin, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.full(quad).apply(Modifiers.cutSide(this.innerMax, this.outerMin, this.outerMax, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.full(quad).apply(Modifiers.cutSide(this.innerMin, this.outerMin, this.innerMax, this.innerMin)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
                QuadModifier.full(quad).apply(Modifiers.cutSide(this.innerMin, this.innerMax, this.innerMax, this.outerMax)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(null));
            }
            if (this.mapFrame && !this.leather) {
                QuadModifier.full(quad).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(0.0625f)).export(quadMap.get(quadFace));
            }
        } else if (Utils.isY(quadFace)) {
            QuadModifier.full(quad).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), 0.0625f)).applyIf(Modifiers.cutTopBottom(this.facing.m_122427_().m_122434_(), this.outerMax), !this.mapFrame).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).applyIf(Modifiers.setPosition(this.outerMax), !this.mapFrame).export(quadMap.get(null));
            if (!this.mapFrame) {
                QuadModifier.full(quad).apply(Modifiers.cutTopBottom(this.facing, 0.96875f)).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), 0.0625f)).apply(Modifiers.cutTopBottom(this.facing.m_122427_().m_122434_(), this.innerLength)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(this.innerPos)).export(quadMap.get(null));
            }
        } else {
            QuadModifier.full(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122424_(), 0.0625f)).applyIf(Modifiers.cutSideUpDown(this.outerMax), !this.mapFrame).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).applyIf(Modifiers.setPosition(this.outerMax), !this.mapFrame).export(quadMap.get(null));
            if (!this.mapFrame) {
                QuadModifier.full(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.96875f)).apply(Modifiers.cutSideLeftRight(this.facing.m_122424_(), 0.0625f)).apply(Modifiers.cutSideUpDown(this.innerLength)).applyIf(Modifiers.applyLightmap(5, 0), this.glowing).apply(Modifiers.setPosition(this.innerPos)).export(quadMap.get(null));
            }
        }
    }

    @Override
    protected ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        if (this.leather) {
            return ModelUtils.SOLID;
        }
        return super.getAdditionalRenderTypes(rand, extraData);
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, RandomSource rand, ModelData data, RenderType renderType) {
        if (this.leather) {
            List quads = this.baseModel.getQuads(state, null, rand, data, renderType);
            for (BakedQuad quad : quads) {
                if (quad.m_173410_().m_118413_().equals((Object)ClientUtils.DUMMY_TEXTURE)) continue;
                if (this.glowing) {
                    QuadModifier.full(quad).apply(Modifiers.applyLightmap(5, 0)).modifyInPlace();
                }
                quadMap.get(null).add(quad);
            }
        }
    }

    @Override
    public boolean m_7541_() {
        return false;
    }

    public static FramedItemFrameModel normal(BlockState state, BakedModel baseModel) {
        return new FramedItemFrameModel(state, baseModel, false);
    }

    public static FramedItemFrameModel glowing(BlockState state, BakedModel baseModel) {
        return new FramedItemFrameModel(state, baseModel, true);
    }
}

