/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

public final class PanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (side == dir) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_PANEL -> PanelSkipPredicate.testAgainstPanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> PanelSkipPredicate.testAgainstDoublePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> PanelSkipPredicate.testAgainstPillar(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> PanelSkipPredicate.testAgainstEdge(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> PanelSkipPredicate.testAgainstDividedSlab(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> PanelSkipPredicate.testAgainstDividedPanelHor(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> PanelSkipPredicate.testAgainstDividedPanelVert(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_STAIRS -> PanelSkipPredicate.testAgainstStairs(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> PanelSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> PanelSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> PanelSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS, BlockType.FRAMED_HALF_SLOPE -> PanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> PanelSkipPredicate.testAgainstDividedStairs(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> PanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> PanelSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> PanelSkipPredicate.testAgainstDoubleSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> PanelSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> PanelSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_PANEL -> PanelSkipPredicate.testAgainstStackedSlopePanel(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> PanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> PanelSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> PanelSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> PanelSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> PanelSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER -> PanelSkipPredicate.testAgainstFlatStackedSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER -> PanelSkipPredicate.testAgainstFlatStackedInnerSlopePanelCorner(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> PanelSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> PanelSkipPredicate.testAgainstDoubleHalfSlope(level, pos, state, dir, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> PanelSkipPredicate.testAgainstVerticalSlopedStairs(level, pos, state, dir, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstPanel(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstPanel(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstPillar(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstEdge(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstEdge(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedPanelHor(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstEdge(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstEdge(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedPanelVert(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstPillar(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstPillar(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        if (!Utils.isY(side)) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        Half adjHalf = (Half)adjState.m_61143_((Property)BlockStateProperties.f_61402_);
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstStairs(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstEdge(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstPillar(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStackedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstPanel(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatStackedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstPanel(level, pos, state, dir, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatStackedInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstPanel(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return PanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, (BlockState)states.m_14418_(), side) || PanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (PanelSkipPredicate.getHalfDir(dir, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static HalfDir getHalfDir(Direction dir, Direction side) {
        if (side.m_122434_() != dir.m_122434_()) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

