/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.forge.gametest;

import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.filters.ResourceLocationFilter;
import com.almostreliable.lootjs.forge.gametest.GameTestUtils;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.core.Registry;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@GameTestHolder(value="lootjs")
@PrefixGameTestTemplate(value=false)
public class ItemFilterTests {
    @GameTest(m_177046_="empty_test_structure")
    public void simpleTest(GameTestHelper helper) {
        helper.m_177279_(() -> {
            ExampleLoot loot = new ExampleLoot();
            ItemFilter filter = ItemFilter.hasEnchantment(rl -> rl.equals((Object)Registry.f_122825_.m_7981_((Object)Enchantments.f_44969_)));
            GameTestUtils.assertTrue(helper, filter.test(loot.helmet), "Helmet should pass filter");
            GameTestUtils.assertTrue(helper, filter.test(loot.chestPlate), "Chestplate should pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.sword), "Sword should not pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.book), "Book should not pass filter");
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void enchantmentFilterWithOr(GameTestHelper helper) {
        helper.m_177279_(() -> {
            ExampleLoot loot = new ExampleLoot();
            ItemFilter filter = ItemFilter.hasEnchantment(rl -> rl.equals((Object)Registry.f_122825_.m_7981_((Object)Enchantments.f_44969_))).or(ItemFilter.SWORD);
            GameTestUtils.assertTrue(helper, filter.test(loot.helmet), "Helmet should pass filter");
            GameTestUtils.assertTrue(helper, filter.test(loot.chestPlate), "Chestplate should pass filter");
            GameTestUtils.assertTrue(helper, filter.test(loot.sword), "Sword should pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.book), "Book should not pass filter");
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void enchantmentFilterWithAnd(GameTestHelper helper) {
        helper.m_177279_(() -> {
            ExampleLoot loot = new ExampleLoot();
            ItemFilter filter = ItemFilter.hasEnchantment(rl -> rl.equals((Object)Registry.f_122825_.m_7981_((Object)Enchantments.f_44977_))).and(ItemFilter.SWORD);
            GameTestUtils.assertFalse(helper, filter.test(loot.helmet), "Helmet should not pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.chestPlate), "Chestplate not should pass filter");
            GameTestUtils.assertTrue(helper, filter.test(loot.sword), "Sword should pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.book), "Book should not pass filter");
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void enchantmentFilterWithAndFails(GameTestHelper helper) {
        helper.m_177279_(() -> {
            ExampleLoot loot = new ExampleLoot();
            ItemFilter filter = ItemFilter.hasEnchantment(rl -> rl.equals((Object)Registry.f_122825_.m_7981_((Object)Enchantments.f_44982_))).and(ItemFilter.SWORD);
            GameTestUtils.assertFalse(helper, filter.test(loot.helmet), "Helmet should not pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.chestPlate), "Chestplate not should pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.sword), "Sword should not pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.book), "Book should not pass filter");
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void enchantmentRegex(GameTestHelper helper) {
        helper.m_177279_(() -> {
            ExampleLoot loot = new ExampleLoot();
            ItemFilter filter = ItemFilter.hasEnchantment(new ResourceLocationFilter.ByPattern(Pattern.compile(".*sharpness.*")));
            GameTestUtils.assertFalse(helper, filter.test(loot.helmet), "Helmet should not pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.chestPlate), "Chestplate should not pass filter");
            GameTestUtils.assertTrue(helper, filter.test(loot.sword), "Sword should pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.book), "Book should not pass filter");
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void enchantmentRegexOrLocation(GameTestHelper helper) {
        helper.m_177279_(() -> {
            ExampleLoot loot = new ExampleLoot();
            ResourceLocationFilter.Or rlf = new ResourceLocationFilter.Or(List.of(new ResourceLocationFilter.ByPattern(Pattern.compile(".*sharpness.*")), new ResourceLocationFilter.ByLocation(Objects.requireNonNull(Registry.f_122825_.m_7981_((Object)Enchantments.f_44952_)))));
            ItemFilter filter = ItemFilter.hasEnchantment(rlf);
            GameTestUtils.assertFalse(helper, filter.test(loot.helmet), "Helmet should not pass filter");
            GameTestUtils.assertFalse(helper, filter.test(loot.chestPlate), "Chestplate should not pass filter");
            GameTestUtils.assertTrue(helper, filter.test(loot.sword), "Sword should pass filter");
            GameTestUtils.assertTrue(helper, filter.test(loot.book), "Book should pass filter");
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void enchantmentMinInclusive(GameTestHelper helper) {
        helper.m_177279_(() -> {
            EnchantmentInstance e = new EnchantmentInstance(Enchantments.f_44969_, 2);
            ItemFilter filter = ItemFilter.hasEnchantment(rl -> rl.equals((Object)Registry.f_122825_.m_7981_((Object)Enchantments.f_44969_)), 2, 5);
            GameTestUtils.assertTrue(helper, filter.test(EnchantedBookItem.m_41161_((EnchantmentInstance)e)), "Enchantment in range");
        });
    }

    @GameTest(m_177046_="empty_test_structure")
    public void enchantmentMaxInclusive(GameTestHelper helper) {
        helper.m_177279_(() -> {
            EnchantmentInstance e = new EnchantmentInstance(Enchantments.f_44969_, 5);
            ItemFilter filter = ItemFilter.hasEnchantment(rl -> rl.equals((Object)Registry.f_122825_.m_7981_((Object)Enchantments.f_44969_)), 2, 5);
            GameTestUtils.assertTrue(helper, filter.test(EnchantedBookItem.m_41161_((EnchantmentInstance)e)), "Enchantment in range");
        });
    }

    private static class ExampleLoot {
        private final ItemStack helmet = new ItemStack((ItemLike)Items.f_42468_);
        private final ItemStack sword;
        private final ItemStack book;
        private final ItemStack chestPlate;

        public ExampleLoot() {
            this.helmet.m_41663_(Enchantments.f_44969_, 4);
            this.chestPlate = new ItemStack((ItemLike)Items.f_42468_);
            this.chestPlate.m_41663_(Enchantments.f_44969_, 4);
            this.sword = new ItemStack((ItemLike)Items.f_42383_);
            this.sword.m_41663_(Enchantments.f_44977_, 4);
            this.book = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44952_, 3));
        }
    }
}

