/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.config.CoreClientConfig;
import cofh.core.item.ILeftClickHandlerItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ArcheryHelper;
import cofh.lib.api.item.IEnergyContainerItem;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.item.CrossbowItemCoFH;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class FluxCrossbowItem
extends CrossbowItemCoFH
implements IMultiModeFluxItem,
ILeftClickHandlerItem {
    protected final int maxCharges;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxCrossbowItem(int enchantability, float accuracyModifier, float damageModifier, float velocityModifier, int maxCharges, Item.Properties builder, int energy, int xfer) {
        super(enchantability, accuracyModifier, damageModifier, velocityModifier, builder);
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        this.maxCharges = maxCharges;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.getLoadedAmmoCount(stack) > 0) {
            tooltip.add((Component)Component.m_237115_((String)"info.cofh.crossbow_loaded"));
            for (ItemStack ammo : this.getAllLoadedAmmo(stack)) {
                tooltip.add((Component)Component.m_237113_((String)"- ").m_7220_(ammo.m_41786_()));
            }
        }
        if (Screen.m_96638_() || ((Boolean)CoreClientConfig.alwaysShowDetails.get()).booleanValue()) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (((Boolean)CoreClientConfig.holdShiftForDetails.get()).booleanValue()) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getEnchantmentValue(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this, this.getEnergyCapability());
    }

    public float getAmmoModelProperty(ItemStack stack, Level world, LivingEntity entity, int seed) {
        return (float)this.getLoadedAmmoCount(stack) * 0.334f;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.hasEnergy(stack, false) && this.getLoadedAmmoCount(stack) < this.maxCharges && (player.f_36077_.f_35937_ || !ArcheryHelper.findAmmo((Player)player, (ItemStack)stack).m_41619_())) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity living) {
        if (!world.f_46443_ && this.getLoadedAmmoCount(stack) < this.maxCharges && this.loadAmmo(living, stack)) {
            FluxCrossbowItem.m_40884_((ItemStack)stack, (boolean)true);
            world.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11841_, living instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
        return stack;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity living, int durationRemaining) {
        if (!world.f_46443_ && durationRemaining < 0 && this.getLoadedAmmoCount(stack) < this.maxCharges && this.loadAmmo(living, stack)) {
            FluxCrossbowItem.m_40884_((ItemStack)stack, (boolean)true);
            world.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11841_, living instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    public boolean m_41463_(ItemStack stack) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return player.m_7500_();
    }

    public void onCrossbowShot(Player shooter, InteractionHand hand, ItemStack crossbow, int damage) {
        this.useEnergy(crossbow, Math.min(this.getEnergyPerUse(false) * damage, this.getEnergyStored(crossbow)), shooter.f_36077_.f_35937_);
        if (shooter instanceof ServerPlayer) {
            if (!shooter.f_19853_.m_5776_()) {
                CriteriaTriggers.f_10555_.m_65462_((ServerPlayer)shooter, crossbow);
            }
            shooter.m_36246_(Stats.f_12982_.m_12902_((Object)crossbow.m_41720_()));
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0 || this.getLoadedAmmoCount(oldStack) != this.getLoadedAmmoCount(newStack));
    }

    public ListTag getLoadedAmmoNBT(ItemStack crossbow) {
        CompoundTag tag = crossbow.m_41784_();
        if (tag.m_128441_("Ammo") && tag.m_128435_("Ammo") == 9) {
            return tag.m_128437_("Ammo", 10);
        }
        return new ListTag();
    }

    public ItemStack[] getAllLoadedAmmo(ItemStack crossbow) {
        return (ItemStack[])this.getLoadedAmmoNBT(crossbow).stream().map(nbt -> nbt instanceof CompoundTag ? ItemStack.m_41712_((CompoundTag)((CompoundTag)nbt)) : ItemStack.f_41583_).toArray(ItemStack[]::new);
    }

    public int getLoadedAmmoCount(ItemStack crossbow) {
        return this.getLoadedAmmoNBT(crossbow).size();
    }

    public boolean loadAmmo(Player player, ItemStack crossbow, ItemStack ammo) {
        ListTag list = this.getLoadedAmmoNBT(crossbow);
        list.add((Object)ammo.m_41739_(new CompoundTag()));
        crossbow.m_41784_().m_128365_("Ammo", (Tag)list);
        FluxCrossbowItem.m_40884_((ItemStack)crossbow, (boolean)true);
        return true;
    }

    public ItemStack getLoadedAmmo(ItemStack crossbow) {
        ListTag list = this.getLoadedAmmoNBT(crossbow);
        return list.isEmpty() ? ItemStack.f_41583_ : ItemStack.m_41712_((CompoundTag)list.m_128728_(0));
    }

    public void removeLoadedAmmo(ItemStack crossbow) {
        ListTag list = this.getLoadedAmmoNBT(crossbow);
        if (!list.isEmpty()) {
            list.remove(0);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return IMultiModeFluxItem.super.isBarVisible(stack);
    }

    public int m_142159_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarColor(stack);
    }

    public int m_142158_(ItemStack stack) {
        return IMultiModeFluxItem.super.getBarWidth(stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    public void onLeftClick(Player player, ItemStack stack) {
        if (FluxCrossbowItem.m_40932_((ItemStack)stack)) {
            if (this.isEmpowered(stack)) {
                float xRot = player.f_19858_;
                int count = this.getLoadedAmmoCount(stack);
                for (int i = (1 - count) / 2; i <= count / 2; ++i) {
                    player.f_19858_ = xRot - (float)(10 * i);
                    this.shootLoadedAmmo(player.f_19853_, (LivingEntity)player, InteractionHand.MAIN_HAND, stack);
                }
                player.f_19858_ = xRot;
                FluxCrossbowItem.m_40884_((ItemStack)stack, (boolean)false);
            } else if (this.shootLoadedAmmo(player.f_19853_, (LivingEntity)player, InteractionHand.MAIN_HAND, stack) && this.getLoadedAmmoCount(stack) <= 0) {
                FluxCrossbowItem.m_40884_((ItemStack)stack, (boolean)false);
            }
        }
    }
}

