/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.mekanism.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.kubejs.mekanism.util.ChemicalWrapper;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.InputReplacement;
import dev.latvian.mods.kubejs.recipe.ItemMatch;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.EnumComponent;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentWithParent;
import dev.latvian.mods.kubejs.typings.desc.DescriptionContext;
import dev.latvian.mods.kubejs.typings.desc.TypeDescJS;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import java.util.Map;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.recipe.ingredient.creator.ItemStackIngredientCreator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public interface MekComponents {
    public static final RecipeComponent<ItemStackIngredient> INPUT_ITEM = new RecipeComponent<ItemStackIngredient>(){

        public ComponentRole role() {
            return ComponentRole.INPUT;
        }

        public Class<?> componentClass() {
            return ItemStackIngredient.class;
        }

        public JsonElement write(RecipeJS recipe, ItemStackIngredient value) {
            return value.serialize();
        }

        public ItemStackIngredient read(RecipeJS recipe, Object from) {
            if (from instanceof ItemStackIngredient) {
                ItemStackIngredient in = (ItemStackIngredient)from;
                return in;
            }
            if (from instanceof JsonElement) {
                JsonElement json = (JsonElement)from;
                return (ItemStackIngredient)IngredientCreatorAccess.item().deserialize(json);
            }
            InputItem in = InputItem.of((Object)from);
            return ItemStackIngredientCreator.INSTANCE.from(in.ingredient, in.count);
        }

        public boolean isInput(RecipeJS recipe, ItemStackIngredient value, ReplacementMatch match) {
            if (match instanceof ItemMatch) {
                ItemMatch m = (ItemMatch)match;
                if (value instanceof ItemStackIngredientCreator.SingleItemStackIngredient) {
                    ItemStackIngredientCreator.SingleItemStackIngredient in = (ItemStackIngredientCreator.SingleItemStackIngredient)value;
                    return m.contains(in.getInputRaw());
                }
                if (value instanceof ItemStackIngredientCreator.MultiItemStackIngredient) {
                    ItemStackIngredientCreator.MultiItemStackIngredient in = (ItemStackIngredientCreator.MultiItemStackIngredient)value;
                    for (ItemStackIngredient in1 : in.getIngredients()) {
                        if (!m.contains(((ItemStackIngredientCreator.SingleItemStackIngredient)in1).getInputRaw())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public ItemStackIngredient replaceInput(RecipeJS recipe, ItemStackIngredient original, ReplacementMatch match, InputReplacement with) {
            if (match instanceof ItemMatch) {
                ItemMatch m = (ItemMatch)match;
                if (original instanceof ItemStackIngredientCreator.SingleItemStackIngredient) {
                    ItemStackIngredientCreator.SingleItemStackIngredient in = (ItemStackIngredientCreator.SingleItemStackIngredient)original;
                    if (m.contains(in.getInputRaw())) {
                        InputItem item = InputItem.of((Object)with.replaceInput(recipe, match, (InputReplacement)InputItem.of((Ingredient)in.getInputRaw(), (int)in.getAmountRaw())));
                        return ItemStackIngredientCreator.INSTANCE.from(item.ingredient, item.count);
                    }
                } else if (original instanceof ItemStackIngredientCreator.MultiItemStackIngredient) {
                    ItemStackIngredientCreator.MultiItemStackIngredient in = (ItemStackIngredientCreator.MultiItemStackIngredient)original;
                    List ingredients = in.getIngredients();
                    for (ItemStackIngredient in1 : ingredients) {
                        if (!m.contains(((ItemStackIngredientCreator.SingleItemStackIngredient)in1).getInputRaw())) continue;
                        ItemStackIngredient[] repl = new ItemStackIngredient[ingredients.size()];
                        for (int i = 0; i < repl.length; ++i) {
                            ItemStackIngredientCreator.SingleItemStackIngredient in2 = (ItemStackIngredientCreator.SingleItemStackIngredient)ingredients.get(i);
                            if (m.contains(in2.getInputRaw())) {
                                InputItem item = InputItem.of((Object)with.replaceInput(recipe, match, (InputReplacement)InputItem.of((Ingredient)in2.getInputRaw(), (int)in2.getAmountRaw())));
                                repl[i] = ItemStackIngredientCreator.INSTANCE.from(item.ingredient, item.count);
                                continue;
                            }
                            repl[i] = in2;
                        }
                        return ItemStackIngredientCreator.INSTANCE.createMulti(repl);
                    }
                }
                return original;
            }
            return original;
        }
    };
    public static final RecipeComponent<ChemicalType> CHEMICAL_TYPE = new EnumComponent(ChemicalType.class, ChemicalType::m_7912_, (c, s) -> ChemicalType.fromString((String)s));
    public static final RecipeComponent<ChemicalStackIngredient<?, ?>> ANY_CHEMICAL_INPUT = new RecipeComponent<ChemicalStackIngredient<?, ?>>(){

        public ComponentRole role() {
            return ComponentRole.INPUT;
        }

        public Class<?> componentClass() {
            return ChemicalStackIngredient.class;
        }

        public JsonElement write(RecipeJS recipe, ChemicalStackIngredient<?, ?> value) {
            return value.serialize();
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return TypeDescJS.any((TypeDescJS[])new TypeDescJS[]{MekComponents.chemicalWithAmount(ChemicalWrapper.GAS, ctx), MekComponents.chemicalWithAmount(ChemicalWrapper.INFUSE_TYPE, ctx), MekComponents.chemicalWithAmount(ChemicalWrapper.PIGMENT, ctx), MekComponents.chemicalWithAmount(ChemicalWrapper.SLURRY, ctx)});
        }

        public ChemicalStackIngredient<?, ?> read(RecipeJS recipe, Object from) {
            if (from instanceof ChemicalStackIngredient) {
                ChemicalStackIngredient in = (ChemicalStackIngredient)from;
                return in;
            }
            if (from instanceof Map || from instanceof JsonObject) {
                ChemicalWrapper<?, ?, ?> cw;
                Map map = MapJS.of((Object)from);
                ChemicalWrapper<?, ?, ?> chemicalWrapper = cw = map == null || map.isEmpty() ? null : ChemicalWrapper.find(map);
                if (cw != null) {
                    long amount;
                    Object id = map.get(cw.key());
                    long l = amount = map.containsKey("amount") ? ((Number)map.get("amount")).longValue() : cw.defaultAmount();
                    if (id != null) {
                        return cw.ingredient(id.toString(), amount);
                    }
                    if (map.containsKey("tag")) {
                        return cw.creator().from(TagKey.m_203882_((ResourceKey)((ResourceKey)UtilsJS.cast(cw.registry())), (ResourceLocation)new ResourceLocation(map.get("tag").toString())), amount);
                    }
                }
            }
            throw new RecipeExceptionJS("Cannot read chemical stack ingredient from " + from);
        }

        public void writeToJson(RecipeJS recipe, RecipeComponentValue<ChemicalStackIngredient<?, ?>> cv, JsonObject json) {
            super.writeToJson(recipe, cv, json);
            json.addProperty("chemicalType", ChemicalType.getTypeFor((ChemicalStackIngredient)((ChemicalStackIngredient)cv.value)).m_7912_());
        }

        public void readFromJson(RecipeJS recipe, RecipeComponentValue<ChemicalStackIngredient<?, ?>> cv, JsonObject json) {
            ChemicalType chemicalType = SerializerHelper.getChemicalType((JsonObject)json);
            cv.value = IngredientCreatorAccess.getCreatorForType((ChemicalType)chemicalType).deserialize(json.get(cv.key.name));
        }

        public void readFromMap(RecipeJS recipe, RecipeComponentValue<ChemicalStackIngredient<?, ?>> cv, Map<?, ?> map) {
            ChemicalType chemicalType = ChemicalType.fromString((String)map.get("chemicalType").toString());
            cv.value = IngredientCreatorAccess.getCreatorForType((ChemicalType)chemicalType).deserialize(JsonIO.of(map.get(cv.key.name)));
        }
    };
    public static final RecipeComponent<ChemicalStack<?>> BOXED_CHEMICAL_OUTPUT = new RecipeComponent<ChemicalStack<?>>(){

        public ComponentRole role() {
            return ComponentRole.OUTPUT;
        }

        public Class<?> componentClass() {
            return ChemicalStack.class;
        }

        public JsonElement write(RecipeJS recipe, ChemicalStack<?> value) {
            return SerializerHelper.serializeBoxedChemicalStack((BoxedChemicalStack)BoxedChemicalStack.box(value));
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return TypeDescJS.any((TypeDescJS[])new TypeDescJS[]{MekComponents.chemicalWithAmount(ChemicalWrapper.GAS, ctx), MekComponents.chemicalWithAmount(ChemicalWrapper.INFUSE_TYPE, ctx), MekComponents.chemicalWithAmount(ChemicalWrapper.PIGMENT, ctx), MekComponents.chemicalWithAmount(ChemicalWrapper.SLURRY, ctx)});
        }

        public ChemicalStack<?> read(RecipeJS recipe, Object from) {
            if (from instanceof ChemicalStack) {
                ChemicalStack in = (ChemicalStack)from;
                return in;
            }
            if (from instanceof Map || from instanceof JsonObject) {
                ChemicalWrapper<?, ?, ?> cw;
                Map map = MapJS.of((Object)from);
                ChemicalWrapper<?, ?, ?> chemicalWrapper = cw = map == null || map.isEmpty() ? null : ChemicalWrapper.find(map);
                if (cw != null && map.containsKey(cw.key())) {
                    Object id = map.get(cw.key());
                    long amount = map.containsKey("amount") ? ((Number)map.get("amount")).longValue() : cw.defaultAmount();
                    return cw.stack(id.toString(), amount);
                }
            }
            throw new RecipeExceptionJS("Cannot read boxed chemical stack from " + from);
        }
    };
    public static final RecipeComponent<ChemicalStackIngredient.GasStackIngredient> GAS_INPUT = new ChemicalWrapper.InputComponent<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>(ChemicalWrapper.GAS);
    public static final RecipeComponent<ChemicalStackIngredient.InfusionStackIngredient> INFUSE_TYPE_INPUT = new ChemicalWrapper.InputComponent<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient>(ChemicalWrapper.INFUSE_TYPE);
    public static final RecipeComponent<ChemicalStackIngredient.PigmentStackIngredient> PIGMENT_INPUT = new ChemicalWrapper.InputComponent<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient>(ChemicalWrapper.PIGMENT);
    public static final RecipeComponent<ChemicalStackIngredient.SlurryStackIngredient> SLURRY_INPUT = new ChemicalWrapper.InputComponent<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient>(ChemicalWrapper.SLURRY);
    public static final RecipeComponent<GasStack> GAS_OUTPUT = new ChemicalWrapper.OutputComponent<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>(ChemicalWrapper.GAS);
    public static final RecipeComponent<InfusionStack> INFUSE_TYPE_OUTPUT = new ChemicalWrapper.OutputComponent<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient>(ChemicalWrapper.INFUSE_TYPE);
    public static final RecipeComponent<PigmentStack> PIGMENT_OUTPUT = new ChemicalWrapper.OutputComponent<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient>(ChemicalWrapper.PIGMENT);
    public static final RecipeComponent<SlurryStack> SLURRY_OUTPUT = new ChemicalWrapper.OutputComponent<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient>(ChemicalWrapper.SLURRY);
    public static final RecipeComponent<OutputItem> SECONDARY_OUTPUT_COMPONENT = new RecipeComponentWithParent<OutputItem>(){

        public RecipeComponent<OutputItem> parentComponent() {
            return ItemComponents.OUTPUT;
        }

        public void writeToJson(RecipeJS recipe, RecipeComponentValue<OutputItem> cv, JsonObject json) {
            ItemComponents.OUTPUT.writeToJson(recipe, cv, json);
            if (((OutputItem)cv.value).hasChance()) {
                json.addProperty("secondaryChance", (Number)((OutputItem)cv.value).getChance());
            }
        }

        public void readFromJson(RecipeJS recipe, RecipeComponentValue<OutputItem> cv, JsonObject json) {
            ItemComponents.OUTPUT.readFromJson(recipe, cv, json);
            if (cv.value != null && json.has("secondaryChance")) {
                cv.value = ((OutputItem)cv.value).withChance(json.get("secondaryChance").getAsDouble());
            }
        }

        public void readFromMap(RecipeJS recipe, RecipeComponentValue<OutputItem> cv, Map<?, ?> map) {
            ItemComponents.OUTPUT.readFromMap(recipe, cv, map);
            if (cv.value != null && map.containsKey("secondaryChance")) {
                cv.value = ((OutputItem)cv.value).withChance(((Number)map.get("secondaryChance")).doubleValue());
            }
        }
    };
    public static final RecipeComponent<FloatingLong> FLOATING_LONG = new RecipeComponent<FloatingLong>(){

        public Class<?> componentClass() {
            return FloatingLong.class;
        }

        public JsonElement write(RecipeJS recipe, FloatingLong value) {
            return new JsonPrimitive((Number)value);
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return TypeDescJS.NUMBER;
        }

        public FloatingLong read(RecipeJS recipe, Object from) {
            if (from instanceof FloatingLong) {
                FloatingLong n = (FloatingLong)from;
                return n;
            }
            if (from instanceof Number) {
                Number n = (Number)from;
                return FloatingLong.createConst((double)n.doubleValue());
            }
            try {
                String string;
                if (from instanceof JsonElement) {
                    JsonElement json = (JsonElement)from;
                    string = json.getAsNumber().toString();
                } else {
                    string = from.toString();
                }
                return FloatingLong.parseFloatingLong((String)string, (boolean)true);
            }
            catch (Exception ex) {
                throw new RecipeExceptionJS("Expected floating long to be a positive decimal number");
            }
        }
    };

    @NotNull
    private static TypeDescJS chemicalWithAmount(ChemicalWrapper<?, ?, ?> wrapper, DescriptionContext ctx) {
        return TypeDescJS.object().add(wrapper.key(), wrapper.describe(ctx)).add("amount", TypeDescJS.NUMBER, true);
    }
}

