/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.mekanism.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.typings.desc.DescriptionContext;
import dev.latvian.mods.kubejs.typings.desc.TypeDescJS;
import dev.latvian.mods.kubejs.util.MapJS;
import java.util.Map;
import java.util.function.Function;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public record ChemicalWrapper<C extends Chemical<C>, S extends ChemicalStack<C>, I extends ChemicalStackIngredient<C, S>>(String key, ChemicalType type, ResourceKey<? extends Registry<C>> registry, IChemicalStackIngredientCreator<C, S, I> creator, long defaultAmount, Function<ResourceLocation, C> chemicalFromId, Class<C> chemicalType, Class<S> stackType, Class<I> ingredientType) {
    public static final ChemicalWrapper<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient> GAS = new ChemicalWrapper<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>("gas", ChemicalType.GAS, MekanismAPI.gasRegistryName(), IngredientCreatorAccess.gas(), 1000L, Gas::getFromRegistry, Gas.class, GasStack.class, ChemicalStackIngredient.GasStackIngredient.class);
    public static final ChemicalWrapper<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient> INFUSE_TYPE = new ChemicalWrapper<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient>("infuse_type", ChemicalType.INFUSION, MekanismAPI.infuseTypeRegistryName(), IngredientCreatorAccess.infusion(), 10L, InfuseType::getFromRegistry, InfuseType.class, InfusionStack.class, ChemicalStackIngredient.InfusionStackIngredient.class);
    public static final ChemicalWrapper<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient> PIGMENT = new ChemicalWrapper<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient>("pigment", ChemicalType.PIGMENT, MekanismAPI.pigmentRegistryName(), IngredientCreatorAccess.pigment(), 1000L, Pigment::getFromRegistry, Pigment.class, PigmentStack.class, ChemicalStackIngredient.PigmentStackIngredient.class);
    public static final ChemicalWrapper<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient> SLURRY = new ChemicalWrapper<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient>("slurry", ChemicalType.SLURRY, MekanismAPI.slurryRegistryName(), IngredientCreatorAccess.slurry(), 1000L, Slurry::getFromRegistry, Slurry.class, SlurryStack.class, ChemicalStackIngredient.SlurryStackIngredient.class);
    public static final ChemicalWrapper<?, ?, ?>[] VALUES = new ChemicalWrapper[]{GAS, INFUSE_TYPE, PIGMENT, SLURRY};

    @Nullable
    public static ChemicalWrapper<?, ?, ?> find(Map<?, ?> map) {
        for (ChemicalWrapper<?, ?, ?> wrapper : VALUES) {
            if (!map.containsKey(wrapper.key)) continue;
            return wrapper;
        }
        return null;
    }

    public I ingredient(String id, long amount) {
        if (amount <= 0L) {
            amount = this.defaultAmount;
        }
        if (id.startsWith("#")) {
            TagKey<C> tag = this.tag(id.substring(1));
            return (I)this.creator.from(tag, amount);
        }
        return (I)this.creator.from((IChemicalProvider)this.chemicalFromId.apply(new ResourceLocation(id)), amount);
    }

    public S stack(String id, long amount) {
        if (amount <= 0L) {
            amount = this.defaultAmount;
        }
        return (S)((Chemical)this.chemicalFromId.apply(new ResourceLocation(id))).getStack(amount);
    }

    public TypeDescJS describe(DescriptionContext ctx) {
        return TypeDescJS.STRING.or(ctx.javaType(this.chemicalType));
    }

    private TagKey<C> tag(String id) {
        return this.tag(new ResourceLocation(id));
    }

    private TagKey<C> tag(ResourceLocation id) {
        return TagKey.m_203882_(this.registry, (ResourceLocation)id);
    }

    public record OutputComponent<C extends Chemical<C>, S extends ChemicalStack<C>, I extends ChemicalStackIngredient<C, S>>(ChemicalWrapper<C, S, I> wrapper) implements RecipeComponent<S>
    {
        public ComponentRole role() {
            return ComponentRole.OUTPUT;
        }

        public Class<?> componentClass() {
            return this.wrapper.stackType;
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return TypeDescJS.object().add(this.wrapper.key, this.wrapper.describe(ctx)).add("amount", TypeDescJS.NUMBER).or(this.wrapper.describe(ctx));
        }

        public JsonElement write(RecipeJS recipe, S value) {
            JsonObject json = new JsonObject();
            json.addProperty(this.wrapper.key, value.getTypeRegistryName().toString());
            json.addProperty("amount", (Number)value.getAmount());
            return json;
        }

        public S read(RecipeJS recipe, Object from) {
            if (this.wrapper.ingredientType.isInstance(from)) {
                return (S)((ChemicalStack)from);
            }
            if (from instanceof JsonObject || from instanceof Map) {
                JsonObject json = MapJS.json((Object)from);
                long amount = json.has("amount") ? json.get("amount").getAsLong() : 0L;
                return this.wrapper.stack(json.get(this.wrapper.key).getAsString(), amount);
            }
            if (from instanceof CharSequence) {
                return this.wrapper.stack(from.toString(), this.wrapper.defaultAmount);
            }
            return null;
        }
    }

    public record InputComponent<C extends Chemical<C>, S extends ChemicalStack<C>, I extends ChemicalStackIngredient<C, S>>(ChemicalWrapper<C, S, I> wrapper) implements RecipeComponent<I>
    {
        public ComponentRole role() {
            return ComponentRole.INPUT;
        }

        public Class<?> componentClass() {
            return this.wrapper.ingredientType;
        }

        public JsonElement write(RecipeJS recipe, I value) {
            return value.serialize();
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return TypeDescJS.object().add(this.wrapper.key, this.wrapper.describe(ctx)).add("amount", TypeDescJS.NUMBER).or(this.wrapper.describe(ctx));
        }

        public I read(RecipeJS recipe, Object from) {
            Map map;
            if (this.wrapper.ingredientType.isInstance(from)) {
                return (I)((ChemicalStackIngredient)from);
            }
            if (from instanceof CharSequence) {
                return this.wrapper.ingredient(from.toString(), this.wrapper.defaultAmount);
            }
            if ((from instanceof Map || from instanceof JsonObject) && (map = MapJS.of((Object)from)) != null) {
                long amount;
                Object id = map.get(this.wrapper.key());
                long l = amount = map.containsKey("amount") ? ((Number)map.get("amount")).longValue() : this.wrapper.defaultAmount;
                if (id != null) {
                    return this.wrapper.ingredient(id.toString(), amount);
                }
                if (map.containsKey("tag")) {
                    return (I)this.wrapper.creator().from(this.wrapper.tag(map.get("tag").toString()), amount);
                }
            }
            return null;
        }
    }
}

