/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.api.field;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.phys.AABB;

public enum MiniaturizationFieldSize implements StringRepresentable
{
    INACTIVE("inactive", 0, 0),
    SMALL("small", 1, 3),
    MEDIUM("medium", 2, 5),
    LARGE("large", 3, 7),
    ABSURD("absurd", 4, 9);

    private final int size;
    private final int projectorDistance;
    private final String name;
    public static final Codec<MiniaturizationFieldSize> CODEC;
    public static final MiniaturizationFieldSize[] VALID_SIZES;

    private MiniaturizationFieldSize(String name, int size, int distance) {
        this.size = size;
        this.projectorDistance = distance;
        this.name = name;
    }

    @Nonnull
    public static Optional<MiniaturizationFieldSize> fromDimensions(double size) {
        if (size < (double)SMALL.getDimensions() || size > (double)MiniaturizationFieldSize.maximum().getDimensions() || size % 2.0 == 0.0) {
            return Optional.empty();
        }
        return Arrays.stream(MiniaturizationFieldSize.values()).filter(s -> (double)s.getDimensions() == size).findFirst();
    }

    public static boolean canFitDimensions(int dims) {
        return dims >= 1 && dims <= ABSURD.getDimensions();
    }

    public int getProjectorDistance() {
        return this.projectorDistance;
    }

    public int getDimensions() {
        return this.size * 2 + 1;
    }

    public int getSize() {
        return this.size;
    }

    public String getName() {
        return this.name;
    }

    public static MiniaturizationFieldSize maximum() {
        return ABSURD;
    }

    public BlockPos getCenterFromProjector(BlockPos projector, Direction facing) {
        return projector.m_5484_(facing, this.getProjectorDistance() + 1);
    }

    public BlockPos getProjectorLocationForDirection(BlockPos center, Direction direction) {
        return center.m_5484_(direction, this.getProjectorDistance() + 1);
    }

    public BlockPos getOriginCenter() {
        return new BlockPos((Vec3i)BlockPos.f_121853_.m_7918_(this.size, this.size, this.size));
    }

    public BlockPos getOriginCenter(int y) {
        return new BlockPos(0, y, 0).m_7918_(this.size, this.size, this.size);
    }

    public BlockPos getOriginCenterFromCorner() {
        return this.getOriginCenter().m_7918_(this.projectorDistance, 0, this.projectorDistance);
    }

    public BlockPos getOriginCenterFromCorner(int y) {
        return this.getOriginCenter(y).m_7918_(this.projectorDistance, 0, this.projectorDistance);
    }

    public Stream<BlockPos> getProjectorLocationsAtOrigin() {
        return Arrays.stream(new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}).filter(d -> d.m_122434_().m_122479_()).map(hor -> this.getProjectorLocationForDirection(this.getOriginCenter(), (Direction)hor));
    }

    public Stream<BlockPos> getProjectorLocationsAtOrigin(int y) {
        return Arrays.stream(new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}).filter(d -> d.m_122434_().m_122479_()).map(hor -> this.getProjectorLocationForDirection(this.getOriginCenter(y), (Direction)hor));
    }

    public Stream<BlockPos> getProjectorLocations(BlockPos center) {
        return Arrays.stream(new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}).filter(d -> d.m_122434_().m_122479_()).map(hor -> this.getProjectorLocationForDirection(center, (Direction)hor));
    }

    public Stream<BlockPos> getProjectorLocationsForAxis(BlockPos center, Direction.Axis axis) {
        Direction posdir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        BlockPos posLocation = this.getProjectorLocationForDirection(center, posdir);
        BlockPos negLocation = this.getProjectorLocationForDirection(center, posdir.m_122424_());
        return Stream.of(posLocation, negLocation);
    }

    public BlockPos getOppositeProjectorPosition(BlockPos projectorPos, Direction projectorFacing) {
        BlockPos center = this.getCenterFromProjector(projectorPos, projectorFacing);
        return this.getProjectorLocationForDirection(center, projectorFacing);
    }

    public AABB getBoundsAtOrigin() {
        return this.getBoundsAtPosition(this.getOriginCenter());
    }

    public AABB getBoundsAtOrigin(int y) {
        return this.getBoundsAtPosition(this.getOriginCenter(y));
    }

    public AABB getBoundsAtPosition(BlockPos center) {
        return new AABB(center).m_82400_((double)this.size);
    }

    public String m_7912_() {
        return this.name;
    }

    public BlockPos getBoundsAsBlockPos() {
        int dims = this.getDimensions();
        return new BlockPos(dims, dims, dims);
    }

    static {
        CODEC = Codec.STRING.xmap(MiniaturizationFieldSize::valueOf, Enum::name);
        VALID_SIZES = new MiniaturizationFieldSize[]{SMALL, MEDIUM, LARGE, ABSURD};
    }
}

