/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.api.recipe.layers;

import dev.compactmods.crafting.api.components.IRecipeComponents;
import dev.compactmods.crafting.api.recipe.layers.IRecipeBlocks;
import dev.compactmods.crafting.api.recipe.layers.RecipeLayerType;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;

public interface IRecipeLayer {
    public Set<String> getComponents();

    public Map<String, Integer> getComponentTotals();

    public Optional<String> getComponentForPosition(BlockPos var1);

    public Stream<BlockPos> getPositionsForComponent(String var1);

    default public boolean requiresAllBlocksIdentified() {
        return true;
    }

    default public boolean matches(IRecipeComponents components, IRecipeBlocks blocks) {
        return !this.requiresAllBlocksIdentified() || blocks.allIdentified();
    }

    public RecipeLayerType<?> getType();

    default public void dropNonRequiredComponents(IRecipeComponents components) {
    }
}

