/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.compactmods.crafting.api.EnumCraftingState;
import dev.compactmods.crafting.api.field.IActiveWorldFields;
import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.api.projector.IProjectorRenderInfo;
import dev.compactmods.crafting.api.recipe.IMiniaturizationRecipe;
import dev.compactmods.crafting.core.CCCapabilities;
import dev.compactmods.crafting.field.render.CraftingPreviewRenderer;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="compactcrafting", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent evt) {
        ClientLevel level;
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(CCCapabilities.TEMP_PROJECTOR_RENDERING).ifPresent(IProjectorRenderInfo::tick);
        }
        if ((level = Minecraft.m_91087_().f_91073_) != null && !Minecraft.m_91087_().m_91104_()) {
            level.getCapability(CCCapabilities.FIELDS).ifPresent(IActiveWorldFields::tickFields);
        }
    }

    @SubscribeEvent
    public static void onWorldRender(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES)) {
            ClientEventHandler.doProjectorRender(event, mc);
            ClientEventHandler.doFieldPreviewRender(event, mc);
        }
    }

    @Nonnull
    private static void doFieldPreviewRender(RenderLevelStageEvent event, Minecraft mc) {
        Camera mainCamera = mc.f_91063_.m_109153_();
        HitResult hitResult = mc.f_91077_;
        double viewDistance = 64.0;
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        mc.f_91073_.getCapability(CCCapabilities.FIELDS).ifPresent(fields -> fields.getFields().filter(field -> Vec3.m_82512_((Vec3i)field.getCenter()).m_82509_((Position)mainCamera.m_90583_(), viewDistance)).filter(field -> field.getCraftingState() == EnumCraftingState.CRAFTING).filter(field -> field.getCurrentRecipe().isPresent()).filter(IMiniaturizationField::enabled).forEach(field -> {
            BlockPos center = field.getCenter();
            PoseStack stack = event.getPoseStack();
            stack.m_85836_();
            Vec3 projectedView = mainCamera.m_90583_();
            stack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
            stack.m_85837_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_());
            IMiniaturizationRecipe rec = field.getCurrentRecipe().get();
            int prog = field.getProgress();
            CraftingPreviewRenderer.render(rec, prog, stack, (MultiBufferSource)buffers, 0xF00000, OverlayTexture.f_118083_);
            stack.m_85849_();
        }));
        buffers.m_109911_();
    }

    private static void doProjectorRender(RenderLevelStageEvent event, Minecraft mc) {
        mc.f_91074_.getCapability(CCCapabilities.TEMP_PROJECTOR_RENDERING).ifPresent(render -> render.render(event.getPoseStack()));
    }
}

