/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.compactmods.crafting.client.render.CCRenderTypes;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class GhostRenderer {
    public static void renderTransparentBlock(BlockState state, @Nullable BlockPos pos, PoseStack matrix, MultiBufferSource buffer) {
        GhostRenderer.renderTransparentBlock(state, pos, matrix, buffer, 100);
    }

    public static void renderTransparentBlock(BlockState state, @Nullable BlockPos pos, PoseStack matrix, MultiBufferSource buffer, int ticksLeft) {
        Minecraft mc = Minecraft.m_91087_();
        BlockColors colors = mc.m_91298_();
        float alpha = ticksLeft >= 100 ? 0.9f : 0.9f * Math.max((float)ticksLeft / 100.0f, 0.1f);
        VertexConsumer builder = buffer.m_6299_(CCRenderTypes.PHANTOM);
        BlockRenderDispatcher dispatcher = mc.m_91289_();
        BakedModel model = dispatcher.m_110910_(state);
        if (model != mc.m_91304_().m_119409_()) {
            for (Direction dir : Direction.values()) {
                model.getQuads(state, dir, mc.f_91073_.f_46441_, ModelData.EMPTY, null).forEach(quad -> GhostRenderer.addQuad(state, pos, matrix, mc, colors, builder, quad, alpha));
            }
            model.getQuads(state, null, mc.f_91073_.f_46441_, ModelData.EMPTY, null).forEach(quad -> GhostRenderer.addQuad(state, pos, matrix, mc, colors, builder, quad, alpha));
        }
    }

    private static void addQuad(BlockState state, @Nullable BlockPos pos, PoseStack matrix, Minecraft mc, BlockColors colors, VertexConsumer builder, BakedQuad quad, float alpha) {
        int color = quad.m_111304_() ? colors.m_92577_(state, (BlockAndTintGetter)mc.f_91073_, pos, quad.m_111305_()) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float trueAlpha = Mth.m_14036_((float)0.01f, (float)alpha, (float)0.06f);
        builder.putBulkData(matrix.m_85850_(), quad, red, green, blue, trueAlpha, 0xF00000, OverlayTexture.f_118083_, false);
    }
}

