/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.datagen;

import dev.compactmods.crafting.datagen.LootTableGenerator;
import dev.compactmods.crafting.datagen.ProjectorStateGenerator;
import dev.compactmods.crafting.datagen.ProxyStateGenerator;
import dev.compactmods.crafting.datagen.RecipeGenerator;
import dev.compactmods.crafting.datagen.SharedStateGenerator;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="compactcrafting", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            DataGeneration.registerServerProviders(event.getGenerator(), event);
        }
        if (event.includeClient()) {
            DataGeneration.registerClientProviders(event.getGenerator(), event);
        }
    }

    private static void registerServerProviders(DataGenerator generator, GatherDataEvent event) {
        generator.m_236039_(event.includeServer(), (DataProvider)new LootTableGenerator(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new RecipeGenerator(generator));
    }

    private static void registerClientProviders(DataGenerator generator, GatherDataEvent event) {
        generator.m_236039_(event.includeClient(), (DataProvider)new SharedStateGenerator(generator, event.getExistingFileHelper()));
        generator.m_236039_(event.includeClient(), (DataProvider)new ProjectorStateGenerator(generator, event.getExistingFileHelper()));
        generator.m_236039_(event.includeClient(), (DataProvider)new ProxyStateGenerator(generator, event.getExistingFileHelper()));
    }
}

