/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.field;

import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.field.IActiveWorldFields;
import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.data.NbtListCollector;
import dev.compactmods.crafting.field.MiniaturizationField;
import dev.compactmods.crafting.network.FieldDeactivatedPacket;
import dev.compactmods.crafting.network.NetworkHandler;
import dev.compactmods.crafting.projector.FieldProjectorBlock;
import dev.compactmods.crafting.projector.FieldProjectorEntity;
import dev.compactmods.crafting.projector.ProjectorHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class ActiveWorldFields
implements IActiveWorldFields,
INBTSerializable<ListTag> {
    private Level level;
    private final HashMap<BlockPos, IMiniaturizationField> fields = new HashMap();
    private final HashMap<BlockPos, LazyOptional<IMiniaturizationField>> laziness = new HashMap();

    public ActiveWorldFields() {
    }

    public ActiveWorldFields(Level level) {
        this();
        this.level = level;
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public Stream<IMiniaturizationField> getFields() {
        return this.fields.values().stream();
    }

    @Override
    public void tickFields() {
        Set<IMiniaturizationField> loaded = this.fields.values().stream().filter(IMiniaturizationField::isLoaded).collect(Collectors.toSet());
        if (loaded.isEmpty()) {
            return;
        }
        CompactCrafting.LOGGER.trace("Loaded count ({}): {}", (Object)this.level.m_46472_().m_135782_(), (Object)loaded.size());
        loaded.forEach(IMiniaturizationField::tick);
    }

    @Override
    public void addFieldInstance(IMiniaturizationField field) {
        field.setLevel(this.level);
        BlockPos center = field.getCenter();
        this.fields.put(center, field);
        LazyOptional lazy = LazyOptional.of(() -> field);
        this.laziness.put(center, (LazyOptional<IMiniaturizationField>)lazy);
        field.setRef((LazyOptional<IMiniaturizationField>)lazy);
        lazy.addListener(lo -> lo.ifPresent(this::unregisterField));
    }

    @Override
    public IMiniaturizationField registerField(IMiniaturizationField field) {
        Optional<BlockPos> anyMissing = ProjectorHelper.getMissingProjectors((BlockGetter)this.level, field.getFieldSize(), field.getCenter()).findFirst();
        if (anyMissing.isPresent()) {
            CompactCrafting.LOGGER.warn("Trying to register an active field with missing projector at {}; real state: {}", (Object)anyMissing.get(), (Object)this.level.m_8055_(anyMissing.get()));
            return field;
        }
        this.addFieldInstance(field);
        field.getProjectorPositions().forEach(pos -> {
            BlockEntity tileAt;
            BlockState stateAt = this.level.m_8055_(pos);
            if (!(stateAt.m_60734_() instanceof FieldProjectorBlock)) {
                return;
            }
            if (stateAt.m_155947_() && (tileAt = this.level.m_7702_(pos)) instanceof FieldProjectorEntity) {
                ((FieldProjectorEntity)tileAt).setFieldRef(field.getRef());
            }
        });
        return field;
    }

    @Override
    public void unregisterField(BlockPos center) {
        if (this.fields.containsKey(center)) {
            IMiniaturizationField removedField = this.fields.remove(center);
            LazyOptional<IMiniaturizationField> removed = this.laziness.remove(center);
            removed.invalidate();
            if (!this.level.f_46443_ && removedField != null) {
                NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.level.m_46745_(removedField.getCenter())), (Object)new FieldDeactivatedPacket(removedField.getFieldSize(), removedField.getCenter()));
            }
        }
    }

    @Override
    public void unregisterField(IMiniaturizationField field) {
        BlockPos center = field.getCenter();
        this.unregisterField(center);
    }

    @Override
    public LazyOptional<IMiniaturizationField> getLazy(BlockPos center) {
        return this.laziness.getOrDefault(center, (LazyOptional<IMiniaturizationField>)LazyOptional.empty());
    }

    @Override
    public Optional<IMiniaturizationField> get(BlockPos center) {
        return Optional.ofNullable(this.fields.getOrDefault(center, null));
    }

    @Override
    public boolean hasActiveField(BlockPos center) {
        return this.fields.containsKey(center);
    }

    @Override
    public Stream<IMiniaturizationField> getFields(ChunkPos chunk) {
        return this.fields.entrySet().stream().filter(p -> new ChunkPos((BlockPos)p.getKey()).equals((Object)chunk)).map(Map.Entry::getValue);
    }

    @Override
    public ResourceKey<Level> getLevel() {
        return this.level.m_46472_();
    }

    public ListTag serializeNBT() {
        return this.getFields().map(IMiniaturizationField::serverData).collect(NbtListCollector.toNbtList());
    }

    public void deserializeNBT(ListTag nbt) {
        nbt.forEach(item -> {
            if (item instanceof CompoundTag) {
                CompoundTag ct = (CompoundTag)item;
                MiniaturizationField field = new MiniaturizationField(ct);
                this.addFieldInstance(field);
            }
        });
    }
}

