/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import dev.compactmods.crafting.client.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class FieldDeactivatedPacket {
    protected static final Codec<FieldDeactivatedPacket> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.xmap(MiniaturizationFieldSize::valueOf, Enum::name).fieldOf("size").forGetter(x -> x.fieldSize), (App)BlockPos.f_121852_.fieldOf("center").forGetter(x -> x.fieldCenter)).apply((Applicative)i, FieldDeactivatedPacket::new));
    private final MiniaturizationFieldSize fieldSize;
    private final BlockPos fieldCenter;
    private final BlockPos[] projectors;

    public FieldDeactivatedPacket(MiniaturizationFieldSize fieldSize, BlockPos fieldCenter) {
        this.fieldSize = fieldSize;
        this.fieldCenter = fieldCenter;
        this.projectors = (BlockPos[])fieldSize.getProjectorLocations(fieldCenter).map(BlockPos::m_7949_).toArray(BlockPos[]::new);
    }

    public FieldDeactivatedPacket(FriendlyByteBuf buf) {
        FieldDeactivatedPacket pkt = (FieldDeactivatedPacket)buf.m_130057_(CODEC);
        this.fieldSize = pkt.fieldSize;
        this.fieldCenter = pkt.fieldCenter;
        this.projectors = (BlockPos[])this.fieldSize.getProjectorLocations(this.fieldCenter).map(BlockPos::m_7949_).toArray(BlockPos[]::new);
    }

    public static boolean handle(FieldDeactivatedPacket message, Supplier<NetworkEvent.Context> context) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleFieldDeactivation(message.fieldCenter));
        return true;
    }

    public static void encode(FieldDeactivatedPacket pkt, FriendlyByteBuf buf) {
        buf.m_130059_(CODEC, (Object)pkt);
    }
}

