/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.recipes.MiniaturizationRecipe;
import io.netty.handler.codec.EncoderException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class MiniaturizationRecipeSerializer
implements RecipeSerializer<MiniaturizationRecipe> {
    public MiniaturizationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        CompactCrafting.LOGGER.debug("Beginning deserialization of recipe: {}", (Object)recipeId.toString());
        DataResult parseResult = MiniaturizationRecipe.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
        if (parseResult.error().isPresent()) {
            DataResult.PartialResult pr = (DataResult.PartialResult)parseResult.error().get();
            CompactCrafting.RECIPE_LOGGER.error("Error loading recipe: " + pr.message());
            return null;
        }
        return parseResult.result().map(r -> {
            r.setId(recipeId);
            return r;
        }).orElse(null);
    }

    @Nullable
    public MiniaturizationRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        CompactCrafting.LOGGER.debug("Starting recipe read: {}", (Object)recipeId);
        if (!buffer.isReadable() || buffer.readableBytes() == 0) {
            CompactCrafting.LOGGER.error("Recipe not readable from buffer: {}", (Object)recipeId);
            return null;
        }
        try {
            MiniaturizationRecipe recipe = (MiniaturizationRecipe)buffer.m_130057_((Codec)MiniaturizationRecipe.CODEC);
            recipe.setId(recipeId);
            CompactCrafting.LOGGER.debug("Finished recipe read: {}", (Object)recipeId);
            return recipe;
        }
        catch (EncoderException ex) {
            CompactCrafting.RECIPE_LOGGER.error("Error reading recipe information from network: " + ex.getMessage());
            return null;
        }
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull MiniaturizationRecipe recipe) {
        CompactCrafting.LOGGER.debug("Sending recipe over network: {}", (Object)recipe.getRecipeIdentifier());
        buffer.m_130059_((Codec)MiniaturizationRecipe.CODEC, (Object)recipe);
    }
}

