/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.blocks;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.recipes.RecipeHelper;
import dev.compactmods.crafting.recipes.blocks.ComponentPositionLookup;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public class ComponentPositionLookupCodec
implements PrimitiveCodec<ComponentPositionLookup> {
    public <T> DataResult<ComponentPositionLookup> read(DynamicOps<T> ops, T input) {
        return Codec.STRING.listOf().listOf().decode(ops, input).flatMap(s -> {
            List layerList = (List)s.getFirst();
            ComponentPositionLookup lookup = new ComponentPositionLookup();
            int zSize = layerList.size();
            String[][] mappedToArray = new String[zSize][];
            for (int z = 0; z < zSize; ++z) {
                List layerComponents = (List)layerList.get(z);
                String[] xValues = new String[layerComponents.size()];
                for (int x = 0; x < layerComponents.size(); ++x) {
                    xValues[x] = (String)layerComponents.get(x);
                }
                mappedToArray[z] = xValues;
            }
            lookup.components.putAll(RecipeHelper.convertMultiArrayToMap(mappedToArray));
            lookup.rebuildComponentTotals();
            return DataResult.success((Object)lookup);
        });
    }

    public <T> T write(DynamicOps<T> ops, ComponentPositionLookup lookup) {
        AABB boundsForBlocks = BlockSpaceUtil.getBoundsForBlocks(lookup.getAllPositions());
        String[][] map = RecipeHelper.generateArrayFromBounds(boundsForBlocks);
        BlockSpaceUtil.getBlocksIn(boundsForBlocks).map(pos -> Pair.of((Object)pos.m_7949_(), (Object)lookup.getRequiredComponentKeyForPosition((BlockPos)pos).orElse("-"))).forEach(pair -> {
            BlockPos p = (BlockPos)pair.getFirst();
            map[p.m_123341_()][p.m_123343_()] = (String)pair.getSecond();
        });
        List fin = Arrays.stream(map).map(ImmutableList::copyOf).collect(Collectors.toList());
        DataResult encoded = Codec.STRING.listOf().listOf().encode(fin, ops, ops.empty());
        return encoded.resultOrPartial(err -> CompactCrafting.LOGGER.error("Failed to encode layer component position lookup: {}", err)).get();
    }
}

