/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.catalyst;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.crafting.api.catalyst.CatalystType;
import dev.compactmods.crafting.api.catalyst.ICatalystMatcher;
import dev.compactmods.crafting.core.CCCatalystTypes;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class ItemTagCatalystMatcher
implements ICatalystMatcher,
CatalystType<ItemTagCatalystMatcher> {
    private static final Codec<ItemTagCatalystMatcher> CODEC = RecordCodecBuilder.create(i -> i.group((App)TagKey.m_203877_((ResourceKey)Registry.f_122904_).fieldOf("tag").forGetter(is -> is.tag)).apply((Applicative)i, ItemTagCatalystMatcher::new));
    private final TagKey<Item> tag;

    public ItemTagCatalystMatcher() {
        this.tag = null;
    }

    public ItemTagCatalystMatcher(TagKey<Item> tag) {
        this.tag = tag;
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (this.tag == null) {
            return true;
        }
        return stack.m_204117_(this.tag);
    }

    @Override
    public CatalystType<?> getType() {
        return (CatalystType)CCCatalystTypes.TAGGED_ITEM_CATALYST.get();
    }

    @Override
    public Set<ItemStack> getPossible() {
        if (this.tag == null) {
            return Collections.emptySet();
        }
        ITagManager it = ForgeRegistries.ITEMS.tags();
        ITag tag2 = it.getTag(this.tag);
        return tag2.stream().map(ItemStack::new).collect(Collectors.toSet());
    }

    @Override
    public Codec<ItemTagCatalystMatcher> getCodec() {
        return CODEC;
    }
}

