/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.components;

import dev.compactmods.crafting.api.components.IRecipeBlockComponent;
import dev.compactmods.crafting.api.components.IRecipeComponent;
import dev.compactmods.crafting.api.components.IRecipeComponents;
import dev.compactmods.crafting.recipes.components.EmptyBlockComponent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.level.block.state.BlockState;

public class MiniaturizationRecipeComponents
implements IRecipeComponents {
    private final Map<String, IRecipeBlockComponent> blockComponents = new HashMap<String, IRecipeBlockComponent>();
    private final Map<String, IRecipeComponent> otherComponents = new HashMap<String, IRecipeComponent>();

    @Override
    public Map<String, IRecipeComponent> getAllComponents() {
        return Stream.concat(this.blockComponents.entrySet().stream(), this.otherComponents.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<String, IRecipeBlockComponent> getBlockComponents() {
        return Collections.unmodifiableMap(this.blockComponents);
    }

    @Override
    public boolean isEmptyBlock(String key) {
        IRecipeBlockComponent comp = this.blockComponents.get(key);
        if (comp == null) {
            return true;
        }
        return comp instanceof EmptyBlockComponent;
    }

    @Override
    public boolean hasBlock(String key) {
        return this.blockComponents.containsKey(key);
    }

    @Override
    public void registerBlock(String key, IRecipeBlockComponent component) {
        this.blockComponents.put(key, component);
    }

    @Override
    public void unregisterBlock(String key) {
        this.blockComponents.remove(key);
    }

    @Override
    public void registerOther(String key, IRecipeComponent component) {
        this.otherComponents.put(key, component);
    }

    @Override
    public int size() {
        return this.otherComponents.size() + this.blockComponents.size();
    }

    @Override
    public void clear() {
        this.otherComponents.clear();
        this.blockComponents.clear();
    }

    @Override
    public Optional<IRecipeBlockComponent> getBlock(String key) {
        if (this.blockComponents.containsKey(key)) {
            IRecipeBlockComponent component = this.blockComponents.get(key);
            return Optional.of(component);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getKey(BlockState state) {
        return this.blockComponents.entrySet().stream().filter(bs -> ((IRecipeBlockComponent)bs.getValue()).matches(state)).map(Map.Entry::getKey).findFirst();
    }

    @Override
    public Stream<String> getEmptyComponents() {
        return this.blockComponents.keySet().stream().filter(bck -> this.blockComponents.get(bck) instanceof EmptyBlockComponent);
    }
}

