/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.util;

import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class BlockSpaceUtil {
    public static AABB getLayerBounds(MiniaturizationFieldSize fieldSize, int layerOffset) {
        AABB fieldBounds = fieldSize.getBoundsAtOrigin();
        return BlockSpaceUtil.getLayerBounds(fieldBounds, layerOffset);
    }

    public static AABB getLayerBounds(AABB fieldBounds, int layerOffset) {
        return new AABB(new Vec3(fieldBounds.f_82288_, fieldBounds.f_82289_ + (double)layerOffset, fieldBounds.f_82290_), new Vec3(fieldBounds.f_82291_, fieldBounds.f_82289_ + (double)layerOffset + 1.0, fieldBounds.f_82293_));
    }

    public static Map<BlockPos, BlockPos> rotatePositionsInPlace(BlockPos[] positions) {
        return BlockSpaceUtil.rotatePositionsInPlace(positions, Rotation.CLOCKWISE_90);
    }

    /*
     * Exception decompiling
     */
    public static Map<BlockPos, BlockPos> rotatePositionsInPlace(BlockPos[] positions, Rotation rot) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean boundsFitsInside(AABB inner, AABB outer) {
        if (inner.m_82385_() > outer.m_82385_()) {
            return false;
        }
        if (inner.m_82362_() > outer.m_82362_()) {
            return false;
        }
        return !(inner.m_82376_() > outer.m_82376_());
    }

    public static Stream<BlockPos> getBlocksIn(MiniaturizationFieldSize fieldSize, int layerOffset) {
        AABB layerBounds = BlockSpaceUtil.getLayerBounds(fieldSize, layerOffset);
        return BlockSpaceUtil.getBlocksIn(layerBounds);
    }

    @Nonnull
    public static Stream<BlockPos> getBlocksIn(AABB bounds) {
        return BlockPos.m_121921_((AABB)bounds.m_82310_(1.0, 1.0, 1.0));
    }

    public static AABB getBoundsForBlocks(BlockPos[] filled) {
        return BlockSpaceUtil.getBoundsForBlocks(Arrays.asList(filled));
    }

    public static AABB getBoundsForBlocks(Collection<BlockPos> filled) {
        if (filled.size() == 0) {
            return AABB.m_165882_((Vec3)Vec3.f_82478_, (double)0.0, (double)0.0, (double)0.0);
        }
        BoundingBox trimmedBounds = null;
        for (BlockPos filledPos : filled) {
            if (trimmedBounds == null) {
                trimmedBounds = BoundingBox.m_162375_((Vec3i)filledPos, (Vec3i)filledPos);
                continue;
            }
            BoundingBox checkPos = BoundingBox.m_162375_((Vec3i)filledPos, (Vec3i)filledPos);
            if (trimmedBounds.m_71049_(checkPos)) continue;
            trimmedBounds.m_162386_(checkPos);
        }
        return AABB.m_82321_(trimmedBounds);
    }

    public static AABB getBoundsForBlocks(Stream<BlockPos> positions) {
        Set<BlockPos> collect = positions.map(BlockPos::m_7949_).collect(Collectors.toSet());
        return BlockSpaceUtil.getBoundsForBlocks(collect);
    }

    public static BlockPos normalizeLayerPosition(AABB fieldBounds, BlockPos pos) {
        return new BlockPos((double)pos.m_123341_() - fieldBounds.f_82288_, (double)pos.m_123342_() - fieldBounds.f_82289_, (double)pos.m_123343_() - fieldBounds.f_82290_);
    }

    public static BlockPos[] normalizeLayerPositions(AABB fieldBounds, BlockPos[] fieldPositions) {
        return (BlockPos[])((Stream)Stream.of(fieldPositions).parallel()).map(p -> BlockSpaceUtil.normalizeLayerPosition(fieldBounds, p)).map(BlockPos::m_7949_).toArray(BlockPos[]::new);
    }

    public static BlockPos denormalizeLayerPosition(AABB realBounds, BlockPos normPos) {
        return new BlockPos(realBounds.f_82288_ + (double)normPos.m_123341_(), realBounds.f_82289_ + (double)normPos.m_123342_(), realBounds.f_82290_ + (double)normPos.m_123343_());
    }

    public static AABB getCenterBounds(AABB bounds) {
        boolean xEven = bounds.m_82362_() % 2.0 == 0.0;
        boolean yEven = bounds.m_82376_() % 2.0 == 0.0;
        boolean zEven = bounds.m_82385_() % 2.0 == 0.0;
        double xExpansion = xEven ? 1.0 : 0.5;
        double yExpansion = yEven ? 1.0 : 0.5;
        double zExpansion = zEven ? 1.0 : 0.5;
        return new AABB(bounds.m_82399_(), bounds.m_82399_()).m_82377_(xExpansion, yExpansion, zExpansion);
    }

    public static Stream<BlockPos> getCenterPositions(AABB bounds) {
        return BlockSpaceUtil.getBlocksIn(BlockSpaceUtil.getCenterBounds(bounds));
    }

    public static Stream<BlockPos> getInnerPositions(AABB bounds) {
        AABB insideBounds = bounds.m_82310_(2.0, 0.0, 2.0).m_82386_(1.0, 0.0, 1.0);
        return BlockSpaceUtil.getBlocksIn(insideBounds);
    }

    public static Stream<BlockPos> getWallPositions(AABB bounds) {
        Set allPositions = BlockSpaceUtil.getBlocksIn(bounds).map(BlockPos::m_7949_).collect(Collectors.toSet());
        Set insidePositions = BlockSpaceUtil.getInnerPositions(bounds).map(BlockPos::m_7949_).collect(Collectors.toSet());
        allPositions.removeAll(insidePositions);
        return allPositions.stream();
    }

    public static BlockPos getOffset(AABB bounds) {
        return new BlockPos(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_);
    }

    public static Stream<BlockPos> getCornersOfBounds(AABB bounds) {
        boolean upperRequired = bounds.f_82292_ > bounds.f_82289_;
        HashSet<BlockPos> positions = new HashSet<BlockPos>(upperRequired ? 8 : 4);
        positions.add(new BlockPos(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_));
        positions.add(new BlockPos(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_ - 1.0));
        positions.add(new BlockPos(bounds.f_82291_ - 1.0, bounds.f_82289_, bounds.f_82290_));
        positions.add(new BlockPos(bounds.f_82291_ - 1.0, bounds.f_82289_, bounds.f_82293_ - 1.0));
        if (upperRequired) {
            positions.add(new BlockPos(bounds.f_82288_, bounds.f_82292_ - 1.0, bounds.f_82290_));
            positions.add(new BlockPos(bounds.f_82288_, bounds.f_82292_ - 1.0, bounds.f_82293_ - 1.0));
            positions.add(new BlockPos(bounds.f_82291_ - 1.0, bounds.f_82292_ - 1.0, bounds.f_82290_));
            positions.add(new BlockPos(bounds.f_82291_ - 1.0, bounds.f_82292_ - 1.0, bounds.f_82293_ - 1.0));
        }
        return positions.stream();
    }

    public static Stream<BlockPos> getCornersOfBounds(MiniaturizationFieldSize fieldSize) {
        return BlockSpaceUtil.getCornersOfBounds(fieldSize.getBoundsAtOrigin());
    }

    private static /* synthetic */ void lambda$rotatePositionsInPlace$6(AABB rotatedBounds, AABB bounds, Map realPositions, BlockPos k, BlockPos rp) {
        BlockPos reNormalized = BlockSpaceUtil.normalizeLayerPosition(rotatedBounds, rp);
        BlockPos realPosition = BlockSpaceUtil.denormalizeLayerPosition(bounds, reNormalized);
        realPositions.put(k.m_7949_(), realPosition.m_7949_());
    }

    private static /* synthetic */ BlockPos lambda$rotatePositionsInPlace$5(BlockPos[] p) {
        return p[1];
    }

    private static /* synthetic */ BlockPos lambda$rotatePositionsInPlace$4(BlockPos[] p) {
        return p[0];
    }
}

