/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.util;

import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.api.recipe.IMiniaturizationRecipe;

public class MathUtil {
    public static double calculateFieldScale(IMiniaturizationField field) {
        double requiredTime = field.getCurrentRecipe().map(IMiniaturizationRecipe::getCraftingTime).orElse(1).intValue();
        return MathUtil.calculateFieldScale(field.getProgress(), requiredTime);
    }

    public static double calculateFieldScale(double progress, double requiredTime) {
        double waveDensity = 0.3;
        double h = 0.2;
        double p = 1.0 - progress / requiredTime;
        double l = Math.PI * 4;
        double n = Math.floor(requiredTime / l) + 0.5;
        double q = 0.5 * Math.cos(waveDensity * (l * n * progress / requiredTime)) + 0.5;
        double scale = p - h * p + h * q;
        return scale;
    }
}

