/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import java.util.List;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.gui.upgrade.SyncUpgradeScreen;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SyncUpgrade
extends UpgradeItem {
    private static final String NBT_TUNING = "Tuning";

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.sync.tuning", SyncUpgrade.getTunedValue(itemstack)));
    }

    @Override
    public void onCompiled(ItemStack stack, ModularRouterBlockEntity router) {
        router.setTunedSyncValue(SyncUpgrade.getTunedValue(stack));
    }

    public static int getTunedValue(ItemStack stack) {
        if (!(stack.m_41720_() instanceof SyncUpgrade) || !stack.m_41782_()) {
            return 0;
        }
        CompoundTag tag = stack.m_41737_("modularrouters");
        return tag == null ? 0 : tag.m_128451_(NBT_TUNING);
    }

    public static void setTunedValue(ItemStack stack, int newValue) {
        if (stack.m_41720_() instanceof SyncUpgrade) {
            stack.m_41698_("modularrouters").m_128405_(NBT_TUNING, newValue);
        }
    }

    @Override
    public TintColor getItemTint() {
        return new TintColor(255, 255, 192);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_ && !player.m_20161_()) {
            SyncUpgradeScreen.openSyncGui(stack, hand);
        } else if (player.m_20161_()) {
            if (!world.f_46443_) {
                SyncUpgrade.setTunedValue(stack, world.f_46441_.m_188503_(((Integer)ConfigHolder.common.router.baseTickRate.get()).intValue()));
                player.m_5661_((Component)Component.m_237110_((String)"modularrouters.itemText.sync.tuning", (Object[])new Object[]{SyncUpgrade.getTunedValue(stack)}), true);
            } else {
                player.m_5496_((SoundEvent)ModSounds.SUCCESS.get(), 1.0f, 1.5f);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

