/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.internal.TextComponentMessageFormatHandler;

public class TranslatableContents
implements ComponentContents {
    private static final Object[] f_237494_ = new Object[0];
    private static final FormattedText f_237495_ = FormattedText.m_130775_((String)"%");
    private static final FormattedText f_237496_ = FormattedText.m_130775_((String)"null");
    private final String f_237497_;
    private final Object[] f_237498_;
    @Nullable
    private Language f_237499_;
    private List<FormattedText> f_237500_ = ImmutableList.of();
    private static final Pattern f_237501_ = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TranslatableContents(String p_237504_) {
        this.f_237497_ = p_237504_;
        this.f_237498_ = f_237494_;
    }

    public TranslatableContents(String p_237506_, Object ... p_237507_) {
        this.f_237497_ = p_237506_;
        this.f_237498_ = p_237507_;
    }

    private void m_237524_() {
        Language language = Language.m_128107_();
        if (language != this.f_237499_) {
            this.f_237499_ = language;
            String s = language.m_6834_(this.f_237497_);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.m_237515_(s, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.f_237500_ = builder.build();
            }
            catch (TranslatableFormatException translatableformatexception) {
                this.f_237500_ = ImmutableList.of((Object)FormattedText.m_130775_((String)s));
            }
        }
    }

    private void m_237515_(String p_237516_, Consumer<FormattedText> p_237517_) {
        Matcher matcher = f_237501_.matcher(p_237516_);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    String s = p_237516_.substring(j, k);
                    if (s.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    p_237517_.accept(FormattedText.m_130775_((String)s));
                }
                String s4 = matcher.group(2);
                String s1 = p_237516_.substring(k, l);
                if ("%".equals(s4) && "%%".equals(s1)) {
                    p_237517_.accept(f_237495_);
                } else {
                    int i1;
                    if (!"s".equals(s4)) {
                        throw new TranslatableFormatException(this, "Unsupported format: '" + s1 + "'");
                    }
                    String s2 = matcher.group(1);
                    int n = i1 = s2 != null ? Integer.parseInt(s2) - 1 : i++;
                    if (i1 < this.f_237498_.length) {
                        p_237517_.accept(this.m_237509_(i1));
                    }
                }
                j = l;
            }
            if (j == 0) {
                j = TextComponentMessageFormatHandler.handle((TranslatableContents)this, p_237517_, (Object[])this.f_237498_, (String)p_237516_);
            }
            if (j < p_237516_.length()) {
                String s3 = p_237516_.substring(j);
                if (s3.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                p_237517_.accept(FormattedText.m_130775_((String)s3));
            }
        }
        catch (IllegalArgumentException illegalargumentexception) {
            throw new TranslatableFormatException(this, (Throwable)illegalargumentexception);
        }
    }

    private FormattedText m_237509_(int p_237510_) {
        if (p_237510_ >= this.f_237498_.length) {
            throw new TranslatableFormatException(this, p_237510_);
        }
        Object object = this.f_237498_[p_237510_];
        if (object instanceof Component) {
            return (Component)object;
        }
        return object == null ? f_237496_ : FormattedText.m_130775_((String)object.toString());
    }

    public <T> Optional<T> m_213724_(FormattedText.StyledContentConsumer<T> p_237521_, Style p_237522_) {
        this.m_237524_();
        for (FormattedText formattedtext : this.f_237500_) {
            Optional optional = formattedtext.m_7451_(p_237521_, p_237522_);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public <T> Optional<T> m_213874_(FormattedText.ContentConsumer<T> p_237519_) {
        this.m_237524_();
        for (FormattedText formattedtext : this.f_237500_) {
            Optional optional = formattedtext.m_5651_(p_237519_);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public MutableComponent m_213698_(@Nullable CommandSourceStack p_237512_, @Nullable Entity p_237513_, int p_237514_) throws CommandSyntaxException {
        Object[] aobject = new Object[this.f_237498_.length];
        for (int i = 0; i < aobject.length; ++i) {
            Object object = this.f_237498_[i];
            aobject[i] = object instanceof Component ? ComponentUtils.m_130731_((CommandSourceStack)p_237512_, (Component)((Component)object), (Entity)p_237513_, (int)p_237514_) : object;
        }
        return MutableComponent.m_237204_((ComponentContents)new TranslatableContents(this.f_237497_, aobject));
    }

    public boolean equals(Object p_237526_) {
        if (this == p_237526_) {
            return true;
        }
        if (p_237526_ instanceof TranslatableContents) {
            TranslatableContents translatablecontents = (TranslatableContents)p_237526_;
            if (this.f_237497_.equals(translatablecontents.f_237497_) && Arrays.equals(this.f_237498_, translatablecontents.f_237498_)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int i = this.f_237497_.hashCode();
        return 31 * i + Arrays.hashCode(this.f_237498_);
    }

    public String toString() {
        return "translation{key='" + this.f_237497_ + "', args=" + Arrays.toString(this.f_237498_) + "}";
    }

    public String m_237508_() {
        return this.f_237497_;
    }

    public Object[] m_237523_() {
        return this.f_237498_;
    }
}

