/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.codexadrian.spirit.data.SyncedData;
import me.codexadrian.spirit.registry.SpiritMisc;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record Tier(ResourceLocation id, String displayName, int requiredSouls, int minSpawnDelay, int maxSpawnDelay, int spawnCount, int spawnRange, int nearbyRange, boolean redstoneControlled, boolean ignoreSpawnConditions, Set<String> blacklist) implements SyncedData
{
    public static Codec<Tier> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)id), (App)Codec.STRING.fieldOf("displayName").forGetter(Tier::displayName), (App)Codec.INT.fieldOf("requiredSouls").forGetter(Tier::requiredSouls), (App)Codec.INT.fieldOf("minSpawnDelay").forGetter(Tier::minSpawnDelay), (App)Codec.INT.fieldOf("maxSpawnDelay").forGetter(Tier::maxSpawnDelay), (App)Codec.INT.fieldOf("spawnCount").forGetter(Tier::spawnCount), (App)Codec.INT.fieldOf("spawnRange").forGetter(Tier::spawnRange), (App)Codec.INT.fieldOf("nearbyRange").forGetter(Tier::nearbyRange), (App)Codec.BOOL.fieldOf("redstoneControlled").orElse((Object)false).forGetter(Tier::redstoneControlled), (App)Codec.BOOL.fieldOf("ignoreSpawnConditions").orElse((Object)false).forGetter(Tier::ignoreSpawnConditions), (App)Tier.createSetCodec(Codec.STRING).orElse(new HashSet()).fieldOf("blacklist").forGetter(Tier::blacklist)).apply((Applicative)instance, Tier::new));
    }

    public ResourceLocation m_6423_() {
        return this.id();
    }

    public RecipeSerializer<?> m_7707_() {
        return SpiritMisc.TIER_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return SpiritMisc.TIER_RECIPE.get();
    }

    @Nullable
    public static Tier getTier(int souls, String type, Level level, boolean getNextTier) {
        Tier storedTier = null;
        ArrayList<Tier> tiers = new ArrayList<Tier>(Tier.getTiers(level));
        if (tiers.isEmpty()) {
            return null;
        }
        tiers.sort(Comparator.comparingInt(value -> -value.requiredSouls()));
        if (!getNextTier && souls < ((Tier)tiers.get(tiers.size() - 1)).requiredSouls()) {
            return null;
        }
        for (Tier tier : tiers) {
            if (type != null && tier.blacklist().contains(type)) continue;
            if (souls < tier.requiredSouls()) {
                storedTier = tier;
                continue;
            }
            if (getNextTier) break;
            storedTier = tier;
            break;
        }
        return storedTier;
    }

    public static Tier getHighestTier(String type, Level level) {
        Tier storedTier = null;
        for (Tier tier : Tier.getTiers(level)) {
            if (type != null && tier.blacklist().contains(type) || storedTier != null && storedTier.requiredSouls() >= tier.requiredSouls()) continue;
            storedTier = tier;
        }
        return storedTier;
    }

    public static Tier getTier(int souls, String type, Level level) {
        return Tier.getTier(souls, type, level, false);
    }

    public static List<Tier> getTiers(Level level) {
        return level.m_7465_().m_44013_(SpiritMisc.TIER_RECIPE.get());
    }

    private static <A> Codec<Set<A>> createSetCodec(Codec<A> codec) {
        return codec.listOf().xmap(HashSet::new, ArrayList::new);
    }
}

