/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import me.codexadrian.spirit.Corrupted;
import me.codexadrian.spirit.platform.fabric.ClientServices;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class})
public class EntityRendererMixin {
    private LivingEntity currentlyRendered;

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void preRender(LivingEntity livingEntity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        if (((Corrupted)livingEntity).isCorrupted()) {
            this.currentlyRendered = livingEntity;
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void postRender(LivingEntity livingEntity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        if (this.currentlyRendered != null) {
            this.currentlyRendered = null;
        }
    }

    @Inject(method={"getRenderType"}, at={@At(value="RETURN")}, cancellable=true)
    private void getRenderType(LivingEntity livingEntity, boolean bl, boolean bl2, boolean bl3, CallbackInfoReturnable<RenderType> cir) {
        if (((Corrupted)livingEntity).isCorrupted()) {
            cir.setReturnValue((Object)ClientServices.SHADERS.getSoulShader(livingEntity, ((LivingEntityRenderer)this).m_5478_((Entity)livingEntity)));
        }
    }
}

