/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.storage.tracking;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.teamabnormals.blueprint.common.world.storage.tracking.IDataManager;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum TrackedDataManager {
    INSTANCE;

    private final BiMap<ResourceLocation, TrackedData<?>> dataMap = HashBiMap.create();
    private final BiMap<Integer, TrackedData<?>> idMap = HashBiMap.create();
    private int nextId = 0;

    private TrackedDataManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public synchronized void registerData(ResourceLocation key, TrackedData<?> trackedData) {
        if (this.dataMap.containsKey((Object)key)) {
            throw new IllegalArgumentException(String.format("A Tracked Data with key '%s' is already registered!", key));
        }
        this.dataMap.put((Object)key, trackedData);
        this.idMap.put((Object)this.nextId, trackedData);
        ++this.nextId;
    }

    public <T> void setValue(Entity entity, TrackedData<T> trackedData, T value) {
        if (!this.dataMap.containsValue(trackedData)) {
            throw new IllegalArgumentException(String.format("No key is registered for this Tracked Data: %s", trackedData));
        }
        ((IDataManager)entity).setValue(trackedData, value);
    }

    public <T> T getValue(Entity entity, TrackedData<T> trackedData) {
        if (!this.dataMap.containsValue(trackedData)) {
            throw new IllegalArgumentException(String.format("No key is registered for this Tracked Data: %s", trackedData));
        }
        return ((IDataManager)entity).getValue(trackedData);
    }

    @Nullable
    public TrackedData<?> getTrackedData(ResourceLocation resourceLocation) {
        return (TrackedData)this.dataMap.get((Object)resourceLocation);
    }

    @Nullable
    public ResourceLocation getKey(TrackedData<?> trackedData) {
        return (ResourceLocation)this.dataMap.inverse().get(trackedData);
    }

    @Nullable
    public TrackedData<?> getTrackedData(int id) {
        return (TrackedData)this.idMap.get((Object)id);
    }

    public int getId(TrackedData<?> trackedData) {
        return (Integer)this.idMap.inverse().get(trackedData);
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        Set<IDataManager.DataEntry<?>> entries;
        Entity target = event.getTarget();
        if (!target.f_19853_.f_46443_ && !(entries = ((IDataManager)target).getEntries(true)).isEmpty()) {
            NetworkUtil.updateTrackedData((ServerPlayer)event.getEntity(), target.m_19879_(), entries);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Set<IDataManager.DataEntry<?>> entries;
        Entity target = event.getEntity();
        if (!target.f_19853_.f_46443_ && !(entries = ((IDataManager)target).getEntries(false)).isEmpty()) {
            NetworkUtil.updateTrackedData(target, entries);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        if (!original.f_19853_.f_46443_) {
            Map<TrackedData<?>, IDataManager.DataEntry<?>> dataMap = ((IDataManager)original).getDataMap();
            if (event.isWasDeath()) {
                dataMap.entrySet().removeIf(entry -> !((TrackedData)entry.getKey()).isPersistent());
            }
            dataMap.values().forEach(IDataManager.DataEntry::markDirty);
            ((IDataManager)event.getEntity()).setDataMap(dataMap);
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        IDataManager dataManager = (IDataManager)player;
        Map<TrackedData<?>, IDataManager.DataEntry<?>> dataMap = dataManager.getDataMap();
        dataMap.values().forEach(IDataManager.DataEntry::markDirty);
        ((IDataManager)player).setDataMap(dataMap);
    }
}

