/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.endimator.effects.EndimationEffectHandler;
import com.teamabnormals.blueprint.core.endimator.effects.EndimationEffectSource;

public interface Endimatable
extends EndimationEffectSource {
    default public EndimatedState getEndimatedState() {
        throw new IllegalStateException("Not implemented!");
    }

    default public PlayableEndimation getPlayingEndimation() {
        return this.getEndimatedState().endimation;
    }

    default public void setPlayingEndimation(PlayableEndimation endimationToPlay) {
        EndimatedState state = this.getEndimatedState();
        PlayableEndimation ending = state.endimation;
        if (ending != endimationToPlay) {
            state.effectHandler.reset();
        }
        this.onEndimationEnd(ending, endimationToPlay);
        this.onEndimationStart(endimationToPlay, ending);
        state.endimation = endimationToPlay;
        state.animationTick = 0;
    }

    default public int getAnimationTick() {
        return this.getEndimatedState().animationTick;
    }

    default public void setAnimationTick(int animationTick) {
        this.getEndimatedState().animationTick = animationTick;
    }

    default public EndimationEffectHandler getEffectHandler() {
        return this.getEndimatedState().effectHandler;
    }

    default public void onEndimationStart(PlayableEndimation endimation, PlayableEndimation oldEndimation) {
    }

    default public void onEndimationEnd(PlayableEndimation endimation, PlayableEndimation newEndimation) {
    }

    default public void resetEndimation() {
        this.setPlayingEndimation(PlayableEndimation.BLANK);
    }

    default public void endimateTick() {
        int duration;
        EndimatedState endimatedState = this.getEndimatedState();
        PlayableEndimation endimation = endimatedState.endimation;
        if (endimation != PlayableEndimation.BLANK && ++endimatedState.animationTick >= (duration = endimation.duration())) {
            PlayableEndimation.LoopType loopType = endimation.loopType();
            if (loopType == PlayableEndimation.LoopType.LOOP) {
                this.setPlayingEndimation(endimation);
            } else if (loopType == PlayableEndimation.LoopType.HOLD) {
                endimatedState.animationTick = duration;
            } else {
                this.resetEndimation();
            }
        }
    }

    default public boolean isNoEndimationPlaying() {
        return this.getPlayingEndimation() == PlayableEndimation.BLANK;
    }

    default public boolean isEndimationPlaying(PlayableEndimation endimation) {
        return this.getPlayingEndimation() == endimation;
    }

    public static final class EndimatedState {
        public final EndimationEffectHandler effectHandler;
        public int animationTick;
        public PlayableEndimation endimation = PlayableEndimation.BLANK;

        public EndimatedState(Endimatable endimatable) {
            this.effectHandler = new EndimationEffectHandler(endimatable);
        }
    }
}

