/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.model;

import com.copycatsplus.copycats.content.copycat.base.model.forge.QuadHelperImpl;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class QuadHelper {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <Source, Destination> void assemblePiece(CopycatRenderContext<Source, Destination> context, int rotation, boolean flipY, MutableVec3 offset, MutableAABB select, MutableCullFace cull) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        QuadHelperImpl.assemblePiece(context, (int)var1_1, (boolean)var2_2, (MutableVec3)var3_3, (MutableAABB)var4_4, (MutableCullFace)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <Source, Destination> void assemblePiece(CopycatRenderContext<Source, Destination> context, int rotation, boolean flipY, MutableVec3 offset, MutableAABB select, MutableCullFace cull, QuadTransform ... transforms) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        QuadHelperImpl.assemblePiece(context, (int)var1_1, (boolean)var2_2, (MutableVec3)var3_3, (MutableAABB)var4_4, (MutableCullFace)var5_5, (QuadTransform[])var6_6);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <Source, Destination> void assembleQuad(CopycatRenderContext<Source, Destination> context) {
        QuadHelperImpl.assembleQuad(context);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <Source, Destination> void assembleQuad(Source source, Destination destination) {
        void var1_1;
        QuadHelperImpl.assembleQuad(source, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <Source, Destination> void assembleQuad(CopycatRenderContext<Source, Destination> context, AABB crop, Vec3 move) {
        void var2_2;
        void var1_1;
        QuadHelperImpl.assembleQuad(context, (AABB)var1_1, (Vec3)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <Source, Destination> void assembleQuad(CopycatRenderContext<Source, Destination> context, AABB crop, Vec3 move, QuadTransform ... transforms) {
        void var3_3;
        void var2_2;
        void var1_1;
        QuadHelperImpl.assembleQuad(context, (AABB)var1_1, (Vec3)var2_2, (QuadTransform[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <Source, Destination> void assembleQuad(Source src, Destination dest, AABB crop, Vec3 move) {
        void var3_3;
        void var2_2;
        void var1_1;
        QuadHelperImpl.assembleQuad(src, var1_1, (AABB)var2_2, (Vec3)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <Source, Destination> void assembleQuad(Source src, Destination dest, AABB crop, Vec3 move, QuadTransform ... transforms) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        QuadHelperImpl.assembleQuad(src, var1_1, (AABB)var2_2, (Vec3)var3_3, (QuadTransform[])var4_4);
    }

    public static class MutableAABB {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;

        MutableAABB(double sizeX, double sizeY, double sizeZ) {
            this.set(0.0, 0.0, 0.0, sizeX, sizeY, sizeZ);
        }

        public MutableAABB move(double dX, double dY, double dZ) {
            this.minX += dX;
            this.maxX += dX;
            this.minY += dY;
            this.maxY += dY;
            this.minZ += dZ;
            this.maxZ += dZ;
            return this;
        }

        public MutableAABB rotate(int angle) {
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            return switch (angle) {
                case 90 -> this.set(16.0 - this.minZ, this.minY, this.minX, 16.0 - this.maxZ, this.maxY, this.maxX);
                case 180 -> this.set(16.0 - this.minX, this.minY, 16.0 - this.minZ, 16.0 - this.maxX, this.maxY, 16.0 - this.maxZ);
                case 270 -> this.set(this.minZ, this.minY, 16.0 - this.minX, this.maxZ, this.maxY, 16.0 - this.maxX);
                default -> this;
            };
        }

        public MutableAABB flipX(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(16.0 - this.minX, this.minY, this.minZ, 16.0 - this.maxX, this.maxY, this.maxZ);
        }

        public MutableAABB flipY(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(this.minX, 16.0 - this.minY, this.minZ, this.maxX, 16.0 - this.maxY, this.maxZ);
        }

        public MutableAABB flipZ(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(this.minX, this.minY, 16.0 - this.minZ, this.maxX, this.maxY, 16.0 - this.maxZ);
        }

        public AABB toAABB() {
            return new AABB(this.minX / 16.0, this.minY / 16.0, this.minZ / 16.0, this.maxX / 16.0, this.maxY / 16.0, this.maxZ / 16.0);
        }

        public MutableAABB set(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            return this;
        }
    }

    public static class MutableVec3 {
        public double x;
        public double y;
        public double z;

        MutableVec3(double x, double y, double z) {
            this.set(x, y, z);
        }

        public MutableVec3 rotate(int angle) {
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            return switch (angle) {
                case 90 -> this.set(16.0 - this.z, this.y, this.x);
                case 180 -> this.set(16.0 - this.x, this.y, 16.0 - this.z);
                case 270 -> this.set(this.z, this.y, 16.0 - this.x);
                default -> this;
            };
        }

        public MutableVec3 flipX(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(16.0 - this.x, this.y, this.z);
        }

        public MutableVec3 flipY(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(this.x, 16.0 - this.y, this.z);
        }

        public MutableVec3 flipZ(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(this.x, this.y, 16.0 - this.z);
        }

        public Vec3 toVec3() {
            return new Vec3(this.x / 16.0, this.y / 16.0, this.z / 16.0);
        }

        public Vec3 toVec3Unscaled() {
            return new Vec3(this.x, this.y, this.z);
        }

        public MutableVec3 set(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }
    }

    public static class MutableCullFace {
        public static final int UP = 2 << Direction.UP.m_122411_();
        public static final int DOWN = 2 << Direction.DOWN.m_122411_();
        public static final int NORTH = 2 << Direction.NORTH.m_122411_();
        public static final int EAST = 2 << Direction.EAST.m_122411_();
        public static final int SOUTH = 2 << Direction.SOUTH.m_122411_();
        public static final int WEST = 2 << Direction.WEST.m_122411_();
        public boolean up;
        public boolean down;
        public boolean north;
        public boolean south;
        public boolean east;
        public boolean west;

        MutableCullFace(int mask) {
            this.set((mask & UP) > 0, (mask & DOWN) > 0, (mask & NORTH) > 0, (mask & SOUTH) > 0, (mask & EAST) > 0, (mask & WEST) > 0);
        }

        public MutableCullFace rotate(int angle) {
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            return switch (angle) {
                case 90 -> this.set(this.up, this.down, this.west, this.east, this.north, this.south);
                case 180 -> this.set(this.up, this.down, this.south, this.north, this.west, this.east);
                case 270 -> this.set(this.up, this.down, this.east, this.west, this.south, this.north);
                default -> this;
            };
        }

        public MutableCullFace flipX(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(this.up, this.down, this.north, this.south, this.west, this.east);
        }

        public MutableCullFace flipY(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(this.down, this.up, this.north, this.south, this.east, this.west);
        }

        public MutableCullFace flipZ(boolean flip) {
            if (!flip) {
                return this;
            }
            return this.set(this.up, this.down, this.south, this.north, this.east, this.west);
        }

        public boolean isCulled(Direction direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> this.down;
                case Direction.UP -> this.up;
                case Direction.NORTH -> this.north;
                case Direction.SOUTH -> this.south;
                case Direction.WEST -> this.west;
                case Direction.EAST -> this.east;
            };
        }

        public MutableCullFace set(boolean up, boolean down, boolean north, boolean south, boolean east, boolean west) {
            this.up = up;
            this.down = down;
            this.north = north;
            this.south = south;
            this.east = east;
            this.west = west;
            return this;
        }
    }

    public static class MutableRotation
    implements QuadTransform {
        private final Vec3 pivot;
        private final Vec3 rotation;
        List<Mutation> mutations = new ArrayList<Mutation>(2);

        public MutableRotation(MutableVec3 pivot, MutableVec3 rotation) {
            this.pivot = pivot.toVec3Unscaled();
            this.rotation = rotation.toVec3Unscaled();
        }

        @Override
        public int[] transformVertices(int[] vertexData, TextureAtlasSprite sprite) {
            vertexData = Arrays.copyOf(vertexData, vertexData.length);
            MutableVec3 mutableVertex = new MutableVec3(0.0, 0.0, 0.0);
            for (int i = 0; i < 4; ++i) {
                Vec3 vertex = BakedQuadHelper.getXYZ((int[])vertexData, (int)i);
                this.undoMutate(mutableVertex.set(vertex.f_82479_ * 16.0, vertex.f_82480_ * 16.0, vertex.f_82481_ * 16.0));
                Vec3 rotated = VecHelper.rotate((Vec3)mutableVertex.toVec3Unscaled().m_82546_(this.pivot), (Vec3)this.rotation).m_82549_(this.pivot);
                BakedQuadHelper.setXYZ((int[])vertexData, (int)i, (Vec3)this.mutate(mutableVertex.set(rotated.f_82479_, rotated.f_82480_, rotated.f_82481_)).toVec3());
            }
            return vertexData;
        }

        private MutableVec3 mutate(MutableVec3 vec3) {
            for (Mutation mutation : this.mutations) {
                mutation.mutate(vec3);
            }
            return vec3;
        }

        private MutableVec3 undoMutate(MutableVec3 vec3) {
            for (int i = this.mutations.size() - 1; i >= 0; --i) {
                Mutation mutation = this.mutations.get(i);
                mutation.undoMutate(vec3);
            }
            return vec3;
        }

        @Override
        public QuadTransform rotate(int angle) {
            this.mutations.add(new Mutation(MutationType.ROTATE, angle));
            return this;
        }

        @Override
        public QuadTransform flipX(boolean flip) {
            if (!flip) {
                return this;
            }
            this.mutations.add(new Mutation(MutationType.MIRROR, 0));
            return this;
        }

        @Override
        public QuadTransform flipY(boolean flip) {
            if (!flip) {
                return this;
            }
            this.mutations.add(new Mutation(MutationType.MIRROR, 1));
            return this;
        }

        @Override
        public QuadTransform flipZ(boolean flip) {
            if (!flip) {
                return this;
            }
            this.mutations.add(new Mutation(MutationType.MIRROR, 2));
            return this;
        }
    }

    public record Mutation(MutationType type, int value) {
        public MutableVec3 mutate(MutableVec3 vec3) {
            return switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case MutationType.ROTATE -> vec3.rotate(this.value);
                case MutationType.MIRROR -> this.value == 0 ? vec3.flipX(true) : (this.value == 1 ? vec3.flipY(true) : (this.value == 2 ? vec3.flipZ(true) : vec3));
            };
        }

        public MutableVec3 undoMutate(MutableVec3 vec3) {
            return switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case MutationType.ROTATE -> vec3.rotate(-this.value);
                case MutationType.MIRROR -> this.value == 0 ? vec3.flipX(true) : (this.value == 1 ? vec3.flipY(true) : (this.value == 2 ? vec3.flipZ(true) : vec3));
            };
        }
    }

    public static enum MutationType {
        ROTATE,
        MIRROR;

    }

    public static interface QuadTransform {
        public int[] transformVertices(int[] var1, TextureAtlasSprite var2);

        public QuadTransform rotate(int var1);

        public QuadTransform flipX(boolean var1);

        public QuadTransform flipY(boolean var1);

        public QuadTransform flipZ(boolean var1);
    }

    public record CopycatRenderContext<Source, Destination>(Source source, Destination destination) {
    }
}

