/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.base.model.forge;

import com.copycatsplus.copycats.content.copycat.base.model.QuadHelper;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class QuadHelperImpl {
    public static <Source extends List<BakedQuad>, Destination extends List<BakedQuad>> void assemblePiece(QuadHelper.CopycatRenderContext<Source, Destination> context, int rotation, boolean flipY, QuadHelper.MutableVec3 offset, QuadHelper.MutableAABB select, QuadHelper.MutableCullFace cull) {
        select.rotate(rotation).flipY(flipY);
        offset.rotate(rotation).flipY(flipY);
        cull.rotate(rotation).flipY(flipY);
        for (BakedQuad quad : (List)context.source()) {
            if (cull.isCulled(quad.m_111306_())) continue;
            QuadHelperImpl.assembleQuad(quad, (List)context.destination(), select.toAABB(), offset.toVec3().m_82492_(select.minX / 16.0, select.minY / 16.0, select.minZ / 16.0));
        }
    }

    public static <Source extends List<BakedQuad>, Destination extends List<BakedQuad>> void assemblePiece(QuadHelper.CopycatRenderContext<Source, Destination> context, int rotation, boolean flipY, QuadHelper.MutableVec3 offset, QuadHelper.MutableAABB select, QuadHelper.MutableCullFace cull, QuadHelper.QuadTransform ... transforms) {
        select.rotate(rotation).flipY(flipY);
        offset.rotate(rotation).flipY(flipY);
        cull.rotate(rotation).flipY(flipY);
        for (QuadHelper.QuadTransform transform : transforms) {
            transform.rotate(rotation).flipY(flipY);
        }
        for (BakedQuad quad : (List)context.source()) {
            if (cull.isCulled(quad.m_111306_())) continue;
            QuadHelperImpl.assembleQuad(quad, (List)context.destination(), select.toAABB(), offset.toVec3().m_82492_(select.minX / 16.0, select.minY / 16.0, select.minZ / 16.0), transforms);
        }
    }

    public static <Source extends List<BakedQuad>, Destination extends List<BakedQuad>> void assembleQuad(QuadHelper.CopycatRenderContext<Source, Destination> context) {
        for (BakedQuad quad : (List)context.source()) {
            QuadHelperImpl.assembleQuad(quad, (List)context.destination());
        }
    }

    public static <Source extends BakedQuad, Destination extends List<BakedQuad>> void assembleQuad(Source src, Destination dest) {
        dest.add((BakedQuad)BakedQuadHelper.clone(src));
    }

    public static <Source extends List<BakedQuad>, Destination extends List<BakedQuad>> void assembleQuad(QuadHelper.CopycatRenderContext<Source, Destination> context, AABB crop, Vec3 move) {
        for (BakedQuad quad : (List)context.source()) {
            QuadHelperImpl.assembleQuad(quad, (List)context.destination(), crop, move);
        }
    }

    public static <Source extends List<BakedQuad>, Destination extends List<BakedQuad>> void assembleQuad(QuadHelper.CopycatRenderContext<Source, Destination> context, AABB crop, Vec3 move, QuadHelper.QuadTransform ... transforms) {
        for (BakedQuad quad : (List)context.source()) {
            QuadHelperImpl.assembleQuad(quad, (List)context.destination(), crop, move, transforms);
        }
    }

    public static <Source extends BakedQuad, Destination extends List<BakedQuad>> void assembleQuad(Source src, Destination dest, AABB crop, Vec3 move) {
        dest.add((BakedQuad)BakedQuadHelper.cloneWithCustomGeometry(src, (int[])BakedModelHelper.cropAndMove((int[])src.m_111303_(), (TextureAtlasSprite)src.m_173410_(), (AABB)crop, (Vec3)move)));
    }

    public static <Source extends BakedQuad, Destination extends List<BakedQuad>> void assembleQuad(Source src, Destination dest, AABB crop, Vec3 move, QuadHelper.QuadTransform ... transforms) {
        int[] vertices = BakedModelHelper.cropAndMove((int[])src.m_111303_(), (TextureAtlasSprite)src.m_173410_(), (AABB)crop, (Vec3)move);
        for (QuadHelper.QuadTransform transform : transforms) {
            vertices = transform.transformVertices(vertices, src.m_173410_());
        }
        dest.add((BakedQuad)BakedQuadHelper.cloneWithCustomGeometry(src, (int[])vertices));
    }
}

