/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.queen_bee.entity.custom;

import com.cerbon.queen_bee.client.sound.QueenBeeFlyingSoundInstance;
import com.cerbon.queen_bee.config.QueenBeeModCommonConfigs;
import com.cerbon.queen_bee.item.QueenBeeModItems;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class QueenBeeEntity
extends PathfinderMob
implements IAnimatable,
FlyingAnimal,
NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(QueenBeeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private UUID persistentAngerTarget;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)39, (int)58);
    private int underWaterTicks;
    private int poisonNimbusCooldown;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);

    public QueenBeeEntity(EntityType<? extends QueenBeeEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21364_ = 20;
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public static AttributeSupplier setAttribute() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22277_, 48.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.4f, true));
        this.f_21345_.m_25352_(1, (Goal)new SetQueenBeeAngryWhenBeeIsAngryGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new SetNearbyBeesAngryGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new SummonAngryBeesGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new QueenBeeHurtByOtherGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new QueenBeeBecomeAngryTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean m_6779_(@NotNull LivingEntity pTarget) {
        boolean isAntennaEnabled = (Boolean)QueenBeeModCommonConfigs.ENABLE_ANTENNA.get();
        if (isAntennaEnabled) {
            String targetDimension = pTarget.f_19853_.m_46472_().m_135782_().toString();
            boolean isTargetInBumblezoneDimension = targetDimension.equals("the_bumblezone:the_bumblezone");
            boolean isTargetWearingAntenna = pTarget.m_6844_(EquipmentSlot.HEAD).m_41720_() == QueenBeeModItems.ANTENNA.get();
            boolean isAntennaEnabledInBlumblezoneDimension = (Boolean)QueenBeeModCommonConfigs.ENABLE_ANTENNA_BUMBLEZONE_DIMENSION.get();
            if (isAntennaEnabledInBlumblezoneDimension && isTargetInBumblezoneDimension && isTargetWearingAntenna) {
                return false;
            }
            if (isTargetWearingAntenna && !isTargetInBumblezoneDimension) {
                return false;
            }
        }
        return super.m_6779_(pTarget);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = pEntity.m_6469_(DamageSource.m_19364_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, pEntity);
            if (pEntity instanceof LivingEntity) {
                if (this.f_19853_.m_46791_() == Difficulty.EASY) {
                    ((LivingEntity)pEntity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
                    ((LivingEntity)pEntity).m_7292_(new MobEffectInstance(MobEffects.f_19604_, 300, 0));
                } else {
                    ((LivingEntity)pEntity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 1));
                    ((LivingEntity)pEntity).m_7292_(new MobEffectInstance(MobEffects.f_19604_, 300, 0));
                }
            }
            this.m_5496_(SoundEvents.f_11692_, 1.0f, 1.0f);
        }
        return flag;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_19390_() && pSource.m_7639_() instanceof LivingEntity && this.m_21660_() && ((Boolean)QueenBeeModCommonConfigs.ENABLE_POISON_NIMBUS.get()).booleanValue() && this.poisonNimbusCooldown == 0 && this.f_19796_.m_188501_() <= 0.2f) {
            this.summonPoisonNimbus();
            this.poisonNimbusCooldown = (Integer)QueenBeeModCommonConfigs.POISON_NIMBUS_COOLDOWN.get();
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void summonPoisonNimbus() {
        LivingEntity target = this.m_5448_();
        if (target != null && target.m_20280_((Entity)this) <= (double)((Integer)QueenBeeModCommonConfigs.TARGET_DISTANCE_TO_SQR.get()).intValue() && this.m_142582_((Entity)target)) {
            PoisonNimbusAreaEffectCloud areaEffectCloud = new PoisonNimbusAreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaEffectCloud.m_19718_((LivingEntity)this);
            areaEffectCloud.m_19734_((Integer)QueenBeeModCommonConfigs.POISON_NIMBUS_DURATION.get());
            areaEffectCloud.m_19712_(((Integer)QueenBeeModCommonConfigs.POISON_NIMBUS_RADIUS.get()).intValue());
            areaEffectCloud.m_19714_(5149489);
            areaEffectCloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, ((Integer)QueenBeeModCommonConfigs.POISON_EFFECT_DURATION.get()).intValue(), ((Integer)QueenBeeModCommonConfigs.POISON_EFFECT_AMPLIFIER.get()).intValue()));
            this.f_19853_.m_7967_((Entity)areaEffectCloud);
        }
    }

    public float m_5610_(@NotNull BlockPos pPos, LevelReader pLevel) {
        return pLevel.m_8055_(pPos).m_60795_() ? 10.0f : 0.0f;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public void m_6457_(@NotNull ServerPlayer pServerPlayer) {
        super.m_6457_(pServerPlayer);
        if (((Boolean)QueenBeeModCommonConfigs.ENABLE_QUEEN_BEE_BOSS_BAR.get()).booleanValue()) {
            this.bossInfo.m_6543_(pServerPlayer);
        }
    }

    public void m_6452_(@NotNull ServerPlayer pServerPlayer) {
        super.m_6452_(pServerPlayer);
        if (((Boolean)QueenBeeModCommonConfigs.ENABLE_QUEEN_BEE_BOSS_BAR.get()).booleanValue()) {
            this.bossInfo.m_6539_(pServerPlayer);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.poisonNimbusCooldown > 0) {
            --this.poisonNimbusCooldown;
        }
    }

    protected void m_8024_() {
        this.underWaterTicks = this.m_20072_() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 20) {
            this.m_6469_(DamageSource.f_19312_, 1.0f);
        }
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, false);
        }
        if (((Boolean)QueenBeeModCommonConfigs.ENABLE_QUEEN_BEE_BOSS_BAR.get()).booleanValue()) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected SoundEvent m_7515_() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new QueenBeeFlyingSoundInstance(this));
        return null;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_11741_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11740_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    protected void m_7840_(double pY, boolean pOnGround, @NotNull BlockState pState, @NotNull BlockPos pPos) {
    }

    public void m_20242_(boolean pNoGravity) {
        super.m_20242_(true);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pPersistentAngerTarget) {
        this.persistentAngerTarget = pPersistentAngerTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 4.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 4.0f, this::attackPredicate));
    }

    private <T extends IAnimatable> PlayState predicate(AnimationEvent<T> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.queen_bee.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <T extends IAnimatable> PlayState attackPredicate(AnimationEvent<T> event) {
        if (this.f_20911_ && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.queen_bee.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            this.f_20911_ = false;
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class SetQueenBeeAngryWhenBeeIsAngryGoal
    extends Goal {
        private final QueenBeeEntity queenBee;

        public SetQueenBeeAngryWhenBeeIsAngryGoal(QueenBeeEntity queenBee) {
            this.queenBee = queenBee;
        }

        public boolean m_8036_() {
            return !this.queenBee.m_21660_();
        }

        public void m_8037_() {
            double d0 = this.queenBee.m_21133_(Attributes.f_22277_);
            AABB aabb = this.queenBee.m_20191_().m_82377_(d0, 10.0, d0);
            List nearbyBees = this.queenBee.f_19853_.m_45976_(Bee.class, aabb);
            for (Bee bee : nearbyBees) {
                if (!bee.m_21660_()) continue;
                LivingEntity target = bee.m_5448_();
                if (target == null || this.queenBee.m_5448_() != null) {
                    return;
                }
                this.queenBee.m_6710_(target);
            }
        }
    }

    static class SetNearbyBeesAngryGoal
    extends Goal {
        private final QueenBeeEntity queenBee;

        public SetNearbyBeesAngryGoal(QueenBeeEntity queenBee) {
            this.queenBee = queenBee;
        }

        public boolean m_8036_() {
            LivingEntity target = this.queenBee.m_5448_();
            return target != null && target.m_6084_() && this.queenBee.m_21660_();
        }

        public void m_8037_() {
            LivingEntity target = this.queenBee.m_5448_();
            if (target == null) {
                return;
            }
            double d0 = this.queenBee.m_21133_(Attributes.f_22277_);
            AABB aabb = this.queenBee.m_20191_().m_82377_(d0, 10.0, d0);
            List nearbyBees = this.queenBee.f_19853_.m_45976_(Bee.class, aabb);
            for (Bee bee : nearbyBees) {
                if (bee.m_6120_() != null) continue;
                bee.m_6710_(target);
            }
        }
    }

    static class SummonAngryBeesGoal
    extends Goal {
        private final QueenBeeEntity queenBee;
        private int cooldown;

        public SummonAngryBeesGoal(QueenBeeEntity queenBee) {
            this.queenBee = queenBee;
        }

        public boolean m_8036_() {
            LivingEntity target = this.queenBee.m_5448_();
            return target != null && target.m_6084_() && this.queenBee.m_21660_() && (Boolean)QueenBeeModCommonConfigs.ENABLE_SUMMON_ANGRY_BEES.get() != false;
        }

        public void m_8056_() {
            this.cooldown = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.queenBee.m_5448_();
            if (target == null) {
                return;
            }
            ++this.cooldown;
            if (this.cooldown >= (Integer)QueenBeeModCommonConfigs.SUMMON_ANGRY_BEES_COOLDOWN.get()) {
                double d0 = this.queenBee.m_21133_(Attributes.f_22277_);
                AABB aabb = this.queenBee.m_20191_().m_82377_(d0, 10.0, d0);
                List nearbyBees = this.queenBee.f_19853_.m_45976_(Bee.class, aabb);
                boolean allStung = nearbyBees.stream().allMatch(Bee::m_27857_);
                if (nearbyBees.isEmpty() || allStung) {
                    for (int i = 0; i < (Integer)QueenBeeModCommonConfigs.ANGRY_BEES_AMOUNT.get(); ++i) {
                        Bee bee = (Bee)EntityType.f_20550_.m_20615_(this.queenBee.f_19853_);
                        if (bee == null) continue;
                        bee.m_6027_(this.queenBee.m_20185_(), this.queenBee.m_20186_(), this.queenBee.m_20189_());
                        bee.m_6710_(target);
                        this.queenBee.f_19853_.m_7967_((Entity)bee);
                    }
                    if (this.cooldown >= (Integer)QueenBeeModCommonConfigs.SUMMON_ANGRY_BEES_COOLDOWN.get()) {
                        this.cooldown = 0;
                    }
                }
            }
        }
    }

    class QueenBeeHurtByOtherGoal
    extends HurtByTargetGoal {
        QueenBeeHurtByOtherGoal(QueenBeeEntity pMob) {
            super((PathfinderMob)pMob, new Class[0]);
        }

        public boolean m_8045_() {
            return QueenBeeEntity.this.m_21660_() && super.m_8045_();
        }

        protected void m_5766_(@NotNull Mob pMob, @NotNull LivingEntity pTarget) {
            if (pMob instanceof QueenBeeEntity && this.f_26135_.m_142582_((Entity)pTarget)) {
                pMob.m_6710_(pTarget);
            }
        }
    }

    static class QueenBeeBecomeAngryTargetGoal
    extends NearestAttackableTargetGoal<Player> {
        public QueenBeeBecomeAngryTargetGoal(QueenBeeEntity pMob) {
            super((Mob)pMob, Player.class, 10, true, false, arg_0 -> ((QueenBeeEntity)pMob).m_21674_(arg_0));
        }

        public boolean m_8036_() {
            return this.queenBeeCanTarget() && super.m_8036_();
        }

        public boolean m_8045_() {
            boolean flag = this.queenBeeCanTarget();
            if (flag && this.f_26135_.m_5448_() != null) {
                return super.m_8045_();
            }
            this.f_26137_ = null;
            return false;
        }

        private boolean queenBeeCanTarget() {
            QueenBeeEntity queenBee = (QueenBeeEntity)this.f_26135_;
            return queenBee.m_21660_();
        }
    }

    static class PoisonNimbusAreaEffectCloud
    extends AreaEffectCloud {
        public PoisonNimbusAreaEffectCloud(Level pLevel, double pX, double pY, double pZ) {
            super(pLevel, pX, pY, pZ);
        }

        public void m_19716_(@NotNull MobEffectInstance pEffectInstance) {
            AABB aabb = this.m_20191_().m_82400_(7.0);
            List nearbyEntities = this.f_19853_.m_45976_(LivingEntity.class, aabb);
            for (LivingEntity entity : nearbyEntities) {
                if (entity instanceof Bee || entity instanceof QueenBeeEntity) continue;
                entity.m_7292_(pEffectInstance);
            }
        }
    }
}

