/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.InputResourceTracker;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import java.util.Arrays;
import java.util.List;

public class LimitedInputSlotObjectPool {
    private LimitedInputSlot[] pool = new LimitedInputSlot[1];
    private int index = -1;

    public <STACK, ITEM, CAP> LimitedInputSlot<STACK, ITEM, CAP> acquire(CAP handler, int slot, InputResourceTracker<STACK, ITEM, CAP> tracker) {
        if (this.index == -1) {
            return new LimitedInputSlot<STACK, ITEM, CAP>(handler, slot, tracker);
        }
        LimitedInputSlot obj = this.pool[this.index];
        --this.index;
        obj.init(handler, slot, tracker);
        return obj;
    }

    public void release(LimitedInputSlot<?, ?, ?> obj) {
        if (this.index == this.pool.length - 1) {
            this.pool = Arrays.copyOf(this.pool, this.pool.length * 2);
        }
        this.pool[++this.index] = obj;
    }

    public void release(List<LimitedInputSlot> slots) {
        if (this.index + slots.size() >= this.pool.length) {
            int slotsFree = this.pool.length - this.index - 1;
            int newLength = this.pool.length + slots.size() - slotsFree;
            this.pool = Arrays.copyOf(this.pool, newLength);
        }
        for (LimitedInputSlot slot : slots) {
            ++this.index;
            this.pool[this.index] = slot;
        }
    }
}

