/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.OutputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import javax.annotation.Nullable;

public class LimitedOutputSlot<STACK, ITEM, CAP> {
    public ResourceType<STACK, ITEM, CAP> type;
    public CAP handler;
    public int slot;
    public OutputResourceTracker<STACK, ITEM, CAP> tracker;
    @Nullable
    private STACK stackInSlotCache = null;

    public LimitedOutputSlot(CAP handler, int slot, OutputResourceTracker<STACK, ITEM, CAP> tracker) {
        this.init(handler, slot, tracker);
    }

    public boolean isDone() {
        if (this.tracker.isDone()) {
            return true;
        }
        if (this.slot > this.type.getSlots(this.handler) - 1) {
            return true;
        }
        STACK stack = this.getStackInSlot();
        long count = this.type.getAmount(stack);
        if (count >= this.type.getMaxStackSize(this.handler, this.slot)) {
            return true;
        }
        return count != 0L && !this.tracker.test(stack);
    }

    public STACK getStackInSlot() {
        if (this.stackInSlotCache == null) {
            this.stackInSlotCache = this.type.getStackInSlot(this.handler, this.slot);
        }
        return this.stackInSlotCache;
    }

    public STACK insert(STACK stack, boolean simulate) {
        if (!simulate) {
            this.stackInSlotCache = null;
        }
        return this.type.insert(this.handler, this.slot, stack, simulate);
    }

    public void init(CAP handler, int slot, OutputResourceTracker<STACK, ITEM, CAP> tracker) {
        this.stackInSlotCache = null;
        this.handler = handler;
        this.tracker = tracker;
        this.slot = slot;
        this.type = tracker.getLimit().resourceId().getResourceType();
        assert (this.type != null);
        this.tracker.visit(this);
    }
}

