/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class ResourceType<STACK, ITEM, CAP> {
    private final Map<ITEM, ResourceLocation> registryKeyCache = new Object2ObjectOpenHashMap();
    public final Capability<CAP> CAPABILITY_KIND;

    public ResourceType(Capability<CAP> CAPABILITY_KIND) {
        this.CAPABILITY_KIND = CAPABILITY_KIND;
    }

    public abstract long getAmount(STACK var1);

    public abstract STACK getStackInSlot(CAP var1, int var2);

    public abstract STACK extract(CAP var1, int var2, long var3, boolean var5);

    public abstract int getSlots(CAP var1);

    public abstract long getMaxStackSize(STACK var1);

    public abstract long getMaxStackSize(CAP var1, int var2);

    public abstract STACK insert(CAP var1, int var2, STACK var3, boolean var4);

    public abstract boolean isEmpty(STACK var1);

    public abstract STACK getEmptyStack();

    public abstract boolean matchesStackType(Object var1);

    public boolean matchesStack(ResourceIdentifier<STACK, ITEM, CAP> resourceId, Object stack) {
        if (!this.matchesStackType(stack)) {
            return false;
        }
        Object stack_ = stack;
        if (this.isEmpty(stack_)) {
            return false;
        }
        ResourceLocation stackId = this.getRegistryKey(stack_);
        return resourceId.matchesStack(stackId);
    }

    public abstract boolean matchesCapabilityType(Object var1);

    public Stream<CAP> getCapabilities(ProgramContext programContext, LabelAccess labelAccess) {
        Optional<ItemStack> disk = programContext.getManager().getDisk();
        if (disk.isEmpty()) {
            return Stream.empty();
        }
        LabelPositionHolder labelPositions = LabelPositionHolder.from(disk.get());
        Stream<BlockPos> positions = labelAccess.roundRobin().gather(labelAccess, labelPositions);
        Stream<LazyOptional> position_direction_pairs = positions.flatMap(pos -> labelAccess.directions().stream().map(dir -> Pair.of((Object)pos, (Object)dir)));
        CableNetwork network = programContext.getNetwork();
        Stream<LazyOptional> caps = position_direction_pairs.map(pair -> {
            BlockPos pos = (BlockPos)pair.getFirst();
            Direction dir = (Direction)pair.getSecond();
            return network.getCapability(this.CAPABILITY_KIND, pos, dir);
        });
        return caps.filter(LazyOptional::isPresent).map(x -> x.orElse(null)).filter(Objects::nonNull);
    }

    public Stream<STACK> collect(CAP cap, LabelAccess labelAccess) {
        Stream.Builder<STACK> rtn = Stream.builder();
        for (int slot = 0; slot < this.getSlots(cap); ++slot) {
            STACK stack;
            if (!labelAccess.slots().contains(slot) || this.isEmpty(stack = this.getStackInSlot(cap, slot))) continue;
            rtn.add(stack);
        }
        return rtn.build();
    }

    public boolean registryKeyExists(ResourceLocation location) {
        return this.getRegistry().containsKey(location);
    }

    public ResourceLocation getRegistryKey(STACK stack) {
        ITEM item = this.getItem(stack);
        ResourceLocation found = this.registryKeyCache.get(item);
        if (found != null) {
            return found;
        }
        found = this.getRegistry().getKey(item);
        assert (found != null);
        this.registryKeyCache.put(item, found);
        return found;
    }

    public abstract IForgeRegistry<ITEM> getRegistry();

    public abstract ITEM getItem(STACK var1);

    public abstract STACK copy(STACK var1);

    protected abstract STACK setCount(STACK var1, long var2);

    public STACK withCount(STACK stack, long count) {
        return this.setCount(this.copy(stack), count);
    }
}

