/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.registry.SFMCapabilityProviderMappers;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.Number;
import ca.teamdman.sfml.ast.NumberRange;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.RoundRobin;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class SFMUtils {
    public static <T> Stream<T> getRecursiveStream(RecursiveBuilder<T> operator, T first) {
        Stream.Builder builder = Stream.builder();
        HashSet debounce = new HashSet();
        ArrayDeque toVisit = new ArrayDeque();
        toVisit.add(first);
        debounce.add(first);
        while (!toVisit.isEmpty()) {
            Object current = toVisit.pop();
            operator.accept(current, next -> {
                if (!debounce.contains(next)) {
                    debounce.add(next);
                    toVisit.add(next);
                }
            }, builder::add);
        }
        return builder.build();
    }

    public static TranslatableContents deserializeTranslation(CompoundTag tag) {
        String key = tag.m_128461_("key");
        Object[] args = tag.m_128437_("args", 8).stream().map(StringTag.class::cast).map(StringTag::m_7916_).toArray();
        return SFMUtils.getTranslatableContents(key, args);
    }

    public static CompoundTag serializeTranslation(TranslatableContents contents) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("key", contents.m_237508_());
        ListTag args = new ListTag();
        for (Object arg : contents.m_237523_()) {
            args.add((Object)StringTag.m_129297_((String)arg.toString()));
        }
        tag.m_128365_("args", (Tag)args);
        return tag;
    }

    public static TranslatableContents getTranslatableContents(String key, Object ... args) {
        return new TranslatableContents(key, args);
    }

    public static TranslatableContents getTranslatableContents(String key) {
        return SFMUtils.getTranslatableContents(key, new Object[0]);
    }

    public static <STACK, ITEM, CAP> Optional<InputStatement> getInputStatementForSlot(LimitedInputSlot<STACK, ITEM, CAP> slot, LabelAccess labelAccess) {
        Object potential = slot.peekExtractPotential();
        if (slot.type.isEmpty(potential)) {
            return Optional.empty();
        }
        long toMove = slot.type.getAmount(potential);
        toMove = Long.min(toMove, slot.tracker.getResourceLimit().limit().quantity().number().value());
        long remainingObligation = slot.tracker.getRemainingRetentionObligation();
        toMove -= Long.min(toMove, remainingObligation);
        Object stack = potential = slot.type.withCount(potential, toMove);
        return SFMResourceTypes.DEFERRED_TYPES.get().getResourceKey(slot.type).map(x -> x).map(resourceTypeResourceKey -> SFMUtils.getInputStatementForStack(resourceTypeResourceKey, slot.type, stack, "temp", slot.slot, false, null)).map(inputStatement -> new InputStatement(new LabelAccess(labelAccess.labels(), labelAccess.directions(), inputStatement.labelAccess().slots(), RoundRobin.disabled()), inputStatement.resourceLimits(), inputStatement.each()));
    }

    public static <STACK, ITEM, CAP> InputStatement getInputStatementForStack(ResourceKey<ResourceType<STACK, ITEM, CAP>> resourceTypeResourceKey, ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, String label, int slot, boolean each, @Nullable Direction direction) {
        LabelAccess labelAccess = new LabelAccess(List.of(new Label(label)), new DirectionQualifier(direction == null ? EnumSet.noneOf(Direction.class) : EnumSet.of(direction)), new NumberRangeSet(new NumberRange[]{new NumberRange(slot, slot)}), RoundRobin.disabled());
        Limit limit = new Limit(new ResourceQuantity(new Number(resourceType.getAmount(stack)), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND), new ResourceQuantity(new Number(0L), ResourceQuantity.IdExpansionBehaviour.NO_EXPAND));
        ResourceLocation stackId = resourceType.getRegistryKey(stack);
        ResourceIdentifier resourceIdentifier = new ResourceIdentifier(resourceTypeResourceKey.m_135782_().m_135827_(), resourceTypeResourceKey.m_135782_().m_135815_(), stackId.m_135827_(), stackId.m_135815_());
        ResourceLimit resourceLimit = new ResourceLimit(resourceIdentifier, limit);
        ResourceLimits resourceLimits = new ResourceLimits(List.of(resourceLimit), ResourceIdSet.EMPTY);
        return new InputStatement(labelAccess, resourceLimits, each);
    }

    public static String truncate(String input, int maxLength) {
        if (input.length() > maxLength) {
            SFM.LOGGER.warn("input too big, truncation has occurred! (len={}, max={}, over={})", (Object)input.length(), (Object)maxLength, (Object)(maxLength - input.length()));
            String truncationWarning = "\n...truncated";
            return input.substring(0, maxLength - truncationWarning.length()) + truncationWarning;
        }
        return input;
    }

    public static Optional<ICapabilityProvider> discoverCapabilityProvider(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return Optional.empty();
        }
        return SFMCapabilityProviderMappers.DEFERRED_MAPPERS.get().getValues().stream().map(mapper -> mapper.getProviderFor((LevelAccessor)level, pos)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public static Stream<BlockPos> get3DNeighboursIncludingKittyCorner(BlockPos pos) {
        Stream.Builder<BlockPos> builder = Stream.builder();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    builder.accept(pos.m_7918_(x, y, z));
                }
            }
        }
        return builder.build();
    }

    public static interface RecursiveBuilder<T> {
        public void accept(T var1, Consumer<T> var2, Consumer<T> var3);
    }
}

