/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.InputResourceTracker;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.program.LimitedInputSlotObjectPool;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record InputStatement(LabelAccess labelAccess, ResourceLimits resourceLimits, boolean each) implements IOStatement
{
    private static final LimitedInputSlotObjectPool SLOT_POOL = new LimitedInputSlotObjectPool();

    @Override
    public void tick(ProgramContext context) {
        context.addInput(this);
    }

    public static void releaseSlots(List<LimitedInputSlot> slots) {
        SLOT_POOL.release(slots);
    }

    public static void releaseSlot(LimitedInputSlot<?, ?, ?> slot) {
        SLOT_POOL.release(slot);
    }

    public void gatherSlots(ProgramContext context, Consumer<LimitedInputSlot<?, ?, ?>> acceptor) {
        Stream<ResourceType> types = this.resourceLimits.resourceLimits().stream().map(ResourceLimit::resourceId).map(x -> x.getResourceType()).distinct();
        if (!this.each) {
            List<InputResourceTracker<?, ?, ?>> inputMatchers = this.resourceLimits.createInputTrackers();
            for (ResourceType type : types::iterator) {
                for (Object capability : type.getCapabilities(context, this.labelAccess)::iterator) {
                    this.gatherSlots(type, capability, inputMatchers, acceptor);
                }
            }
        } else {
            for (ResourceType type : types::iterator) {
                for (Object cap : type.getCapabilities(context, this.labelAccess)::iterator) {
                    List<InputResourceTracker<?, ?, ?>> inputTrackers = this.resourceLimits.createInputTrackers();
                    this.gatherSlots(type, cap, inputTrackers, acceptor);
                }
            }
        }
    }

    private <STACK, ITEM, CAP> void gatherSlots(ResourceType<STACK, ITEM, CAP> type, CAP capability, List<InputResourceTracker<?, ?, ?>> trackers, Consumer<LimitedInputSlot<?, ?, ?>> acceptor) {
        for (int slot = 0; slot < type.getSlots(capability); ++slot) {
            STACK stack;
            if (!this.labelAccess.slots().contains(slot) || type.isEmpty(stack = type.getStackInSlot(capability, slot))) continue;
            for (InputResourceTracker<?, ?, ?> tracker : trackers) {
                if (!tracker.matchesCapabilityType(capability) || !tracker.test(stack)) continue;
                acceptor.accept(SLOT_POOL.acquire(capability, slot, tracker));
            }
        }
    }

    @Override
    public String toString() {
        return "INPUT " + this.resourceLimits + " FROM " + (this.each ? "EACH " : "") + this.labelAccess;
    }

    @Override
    public String toStringPretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("INPUT");
        String rls = this.resourceLimits.toStringPretty(Limit.MAX_QUANTITY_NO_RETENTION);
        if (rls.lines().count() > 1L) {
            sb.append("\n");
            sb.append(rls.lines().map(s -> "  " + s).collect(Collectors.joining("\n")));
            sb.append("\n");
        } else {
            sb.append(" ");
            sb.append(rls);
            sb.append(" ");
        }
        sb.append("FROM ");
        sb.append(this.each ? "EACH " : "");
        sb.append(this.labelAccess);
        return sb.toString();
    }
}

