/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.program.LimitedInputSlot;
import ca.teamdman.sfm.common.program.LimitedOutputSlot;
import ca.teamdman.sfm.common.program.LimitedOutputSlotObjectPool;
import ca.teamdman.sfm.common.program.OutputResourceTracker;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.InputStatement;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.ResourceLimit;
import ca.teamdman.sfml.ast.ResourceLimits;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OutputStatement
implements IOStatement {
    private final LabelAccess labelAccess;
    private final ResourceLimits resourceLimits;
    private final boolean each;
    private int lastInputCapacity = 32;
    private int lastOutputCapacity = 32;

    public OutputStatement(LabelAccess labelAccess, ResourceLimits resourceLimits, boolean each) {
        this.labelAccess = labelAccess;
        this.resourceLimits = resourceLimits;
        this.each = each;
    }

    public static <STACK, ITEM, CAP> void moveTo(LimitedInputSlot<STACK, ITEM, CAP> source, LimitedOutputSlot<STACK, ITEM, CAP> destination) {
        if (!source.type.equals(destination.type)) {
            return;
        }
        STACK potential = source.peekExtractPotential();
        if (!destination.tracker.test(potential)) {
            return;
        }
        STACK remainder = destination.insert(potential, true);
        long toMove = source.type.getAmount(potential) - source.type.getAmount(remainder);
        if (toMove == 0L) {
            return;
        }
        long remainingObligation = source.tracker.getRemainingRetentionObligation();
        remainingObligation = Long.min(toMove -= source.tracker.getExistingRetentionObligation(source.slot), remainingObligation);
        source.tracker.trackRetentionObligation(source.slot, remainingObligation);
        if ((toMove -= remainingObligation) == 0L) {
            source.setDone();
            return;
        }
        toMove = Math.min(toMove, destination.tracker.getMaxTransferable());
        toMove = Math.min(toMove, source.tracker.getMaxTransferable());
        if ((toMove = Math.min(toMove, source.type.getMaxStackSize(potential))) <= 0L) {
            return;
        }
        STACK extracted = source.extract(toMove);
        remainder = destination.insert(extracted, false);
        long moved = source.type.getAmount(extracted) - source.type.getAmount(remainder);
        source.tracker.trackTransfer(moved);
        destination.tracker.trackTransfer(moved);
        if (!destination.type.isEmpty(remainder)) {
            SFM.LOGGER.error("Failed to move all promised items, found {} {}:{}, took {} but had {} left over after insertion. Resource loss may have occurred!!!", potential, (Object)SFMResourceTypes.DEFERRED_TYPES.get().getKey(source.type), (Object)destination.type.getRegistryKey(potential), extracted, remainder);
        }
    }

    @Override
    public void tick(ProgramContext context) {
        if (context.getExecutionPolicy() == ProgramContext.ExecutionPolicy.EXPLORE_BRANCHES) {
            return;
        }
        ArrayList<LimitedInputSlot> inputSlots = new ArrayList<LimitedInputSlot>(this.lastInputCapacity + 27);
        for (InputStatement inputStatement : context.getInputs()) {
            inputStatement.gatherSlots(context, inputSlots::add);
        }
        if (inputSlots.isEmpty()) {
            return;
        }
        this.lastInputCapacity = inputSlots.size();
        ArrayList<LimitedOutputSlot> outputSlots = new ArrayList<LimitedOutputSlot>(this.lastOutputCapacity + 27);
        this.gatherSlots(context, outputSlots::add);
        this.lastOutputCapacity = outputSlots.size();
        Iterator inIt = inputSlots.iterator();
        while (inIt.hasNext()) {
            LimitedInputSlot in = (LimitedInputSlot)inIt.next();
            if (in.isDone()) {
                inIt.remove();
                InputStatement.releaseSlot(in);
                continue;
            }
            Iterator outIt = outputSlots.iterator();
            while (outIt.hasNext()) {
                LimitedOutputSlot out = (LimitedOutputSlot)outIt.next();
                if (out.isDone()) {
                    outIt.remove();
                    LimitedOutputSlotObjectPool.INSTANCE.release(out);
                    continue;
                }
                OutputStatement.moveTo(in, out);
                if (!in.isDone()) continue;
                break;
            }
            if (!outputSlots.isEmpty()) continue;
            break;
        }
        LimitedOutputSlotObjectPool.INSTANCE.release(outputSlots);
        InputStatement.releaseSlots(inputSlots);
    }

    public void gatherSlots(ProgramContext context, Consumer<LimitedOutputSlot<?, ?, ?>> acceptor) {
        Stream<ResourceType> types = this.resourceLimits.resourceLimits().stream().map(ResourceLimit::resourceId).map(x -> x.getResourceType()).distinct();
        if (!this.each) {
            List<OutputResourceTracker<?, ?, ?>> outputTracker = this.resourceLimits.createOutputTrackers();
            for (ResourceType type : types::iterator) {
                for (Object cap : type.getCapabilities(context, this.labelAccess)::iterator) {
                    this.gatherSlots(type, cap, outputTracker, acceptor);
                }
            }
        } else {
            for (ResourceType type : types::iterator) {
                for (Object cap : type.getCapabilities(context, this.labelAccess)::iterator) {
                    List<OutputResourceTracker<?, ?, ?>> outputTracker = this.resourceLimits.createOutputTrackers();
                    this.gatherSlots(type, cap, outputTracker, acceptor);
                }
            }
        }
    }

    private <STACK, ITEM, CAP> void gatherSlots(ResourceType<STACK, ITEM, CAP> type, CAP capability, List<OutputResourceTracker<?, ?, ?>> trackers, Consumer<LimitedOutputSlot<?, ?, ?>> acceptor) {
        for (int slot = 0; slot < type.getSlots(capability); ++slot) {
            if (!this.labelAccess.slots().contains(slot)) continue;
            for (OutputResourceTracker<?, ?, ?> tracker : trackers) {
                if (!tracker.matchesCapabilityType(capability)) continue;
                acceptor.accept(LimitedOutputSlotObjectPool.INSTANCE.acquire(capability, slot, tracker));
            }
        }
    }

    @Override
    public LabelAccess labelAccess() {
        return this.labelAccess;
    }

    @Override
    public ResourceLimits resourceLimits() {
        return this.resourceLimits;
    }

    @Override
    public boolean each() {
        return this.each;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OutputStatement that = (OutputStatement)obj;
        return Objects.equals(this.labelAccess, that.labelAccess) && Objects.equals(this.resourceLimits, that.resourceLimits) && this.each == that.each;
    }

    public int hashCode() {
        return Objects.hash(this.labelAccess, this.resourceLimits, this.each);
    }

    public String toString() {
        return "OUTPUT " + this.resourceLimits + " TO " + (this.each ? "EACH " : "") + this.labelAccess;
    }

    @Override
    public String toStringPretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("OUTPUT");
        String rls = this.resourceLimits.toStringPretty(Limit.MAX_QUANTITY_MAX_RETENTION);
        if (rls.lines().count() > 1L) {
            sb.append("\n");
            sb.append(rls.lines().map(s -> "  " + s).collect(Collectors.joining("\n")));
            sb.append("\n");
        } else {
            sb.append(" ");
            sb.append(rls);
            sb.append(" ");
        }
        sb.append("TO ");
        sb.append(this.each ? "EACH " : "");
        sb.append(this.labelAccess);
        return sb.toString();
    }
}

