/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.SFMUtils;
import ca.teamdman.sfml.SFMLLexer;
import ca.teamdman.sfml.SFMLParser;
import ca.teamdman.sfml.ast.ASTBuilder;
import ca.teamdman.sfml.ast.IOStatement;
import ca.teamdman.sfml.ast.IfStatement;
import ca.teamdman.sfml.ast.OutputStatement;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceQuantity;
import ca.teamdman.sfml.ast.Statement;
import ca.teamdman.sfml.ast.Trigger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public record Program(String name, List<Trigger> triggers, Set<String> referencedLabels, Set<ResourceIdentifier<?, ?, ?>> referencedResources) implements Statement
{
    public static final int MAX_PROGRAM_LENGTH = 80960;
    public static final int MAX_LABEL_LENGTH = 256;

    public static void compile(String programString, BiConsumer<Program, ASTBuilder> onSuccess, Consumer<List<TranslatableContents>> onFailure) {
        Program program;
        ArrayList<TranslatableContents> errors;
        ASTBuilder builder;
        block9: {
            SFMLLexer lexer = new SFMLLexer((CharStream)CharStreams.fromString((String)programString));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SFMLParser parser = new SFMLParser((TokenStream)tokens);
            builder = new ASTBuilder();
            lexer.removeErrorListeners();
            parser.removeErrorListeners();
            errors = new ArrayList<TranslatableContents>();
            ArrayList<String> buildErrors = new ArrayList<String>();
            ListErrorListener listener = new ListErrorListener(buildErrors);
            lexer.addErrorListener((ANTLRErrorListener)listener);
            parser.addErrorListener((ANTLRErrorListener)listener);
            SFMLParser.ProgramContext context = parser.program();
            buildErrors.stream().map(xva$0 -> Constants.LocalizationKeys.PROGRAM_ERROR_LITERAL.get(xva$0)).forEach(errors::add);
            program = null;
            try {
                program = builder.visitProgram(context);
                for (ResourceIdentifier<?, ?, ?> referencedResource : program.referencedResources) {
                    try {
                        ResourceType<?, ?, ?> resourceType = referencedResource.getResourceType();
                        if (resourceType != null) continue;
                        errors.add(Constants.LocalizationKeys.PROGRAM_WARNING_UNKNOWN_RESOURCE_TYPE.get(referencedResource));
                    }
                    catch (ResourceLocationException e) {
                        errors.add(Constants.LocalizationKeys.PROGRAM_ERROR_MALFORMED_RESOURCE_TYPE.get(referencedResource));
                    }
                }
            }
            catch (AssertionError | IllegalArgumentException | ResourceLocationException e) {
                errors.add(Constants.LocalizationKeys.PROGRAM_ERROR_LITERAL.get(((Throwable)e).getMessage()));
            }
            catch (Throwable t) {
                errors.add(Constants.LocalizationKeys.PROGRAM_ERROR_COMPILE_FAILED.get());
                SFM.LOGGER.error("Encountered unhandled error while compiling program", t);
                if (FMLEnvironment.production) break block9;
                String message = t.getMessage();
                if (message != null) {
                    errors.add(SFMUtils.getTranslatableContents(t.getClass().getSimpleName() + ": " + message));
                }
                errors.add(SFMUtils.getTranslatableContents(t.getClass().getSimpleName()));
            }
        }
        if (errors.isEmpty()) {
            onSuccess.accept(program, builder);
        } else {
            onFailure.accept(errors);
        }
    }

    public ArrayList<TranslatableContents> gatherWarnings(ItemStack disk, @Nullable ManagerBlockEntity manager) {
        Level level;
        ArrayList<TranslatableContents> warnings = new ArrayList<TranslatableContents>();
        LabelPositionHolder labels = LabelPositionHolder.from(disk);
        for (String label2 : this.referencedLabels) {
            boolean isUsed = !labels.getPositions(label2).isEmpty();
            if (isUsed) continue;
            warnings.add(Constants.LocalizationKeys.PROGRAM_WARNING_UNUSED_LABEL.get(label2));
        }
        labels.get().keySet().stream().filter(x -> !this.referencedLabels.contains(x)).forEach(label -> warnings.add(Constants.LocalizationKeys.PROGRAM_WARNING_UNDEFINED_LABEL.get(label)));
        Level level2 = level = manager != null ? manager.m_58904_() : null;
        if (level != null) {
            CableNetworkManager.getOrRegisterNetworkFromManagerPosition(manager).ifPresent(network -> labels.forEach((label, pos) -> {
                boolean viable;
                boolean adjacent = network.isAdjacentToCable((BlockPos)pos);
                if (!adjacent) {
                    warnings.add(Constants.LocalizationKeys.PROGRAM_WARNING_DISCONNECTED_LABEL.get(label, String.format("[%d,%d,%d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())));
                }
                if (!(viable = SFMUtils.discoverCapabilityProvider(level, pos).isPresent()) && adjacent) {
                    warnings.add(Constants.LocalizationKeys.PROGRAM_WARNING_CONNECTED_BUT_NOT_VIABLE_LABEL.get(label, String.format("[%d,%d,%d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_())));
                }
            }));
        }
        for (ResourceIdentifier<?, ?, ?> resource : this.referencedResources) {
            Optional<ResourceLocation> loc = resource.getLocation();
            if (loc.isEmpty()) continue;
            ResourceType<?, ?, ?> type = resource.getResourceType();
            if (type == null) {
                warnings.add(Constants.LocalizationKeys.PROGRAM_WARNING_UNKNOWN_RESOURCE_TYPE.get(resource.resourceTypeNamespace + ":" + resource.resourceTypeName, resource));
                continue;
            }
            if (type.registryKeyExists(loc.get())) continue;
            warnings.add(Constants.LocalizationKeys.PROGRAM_WARNING_UNKNOWN_RESOURCE_ID.get(resource));
        }
        this.getDescendantStatements().filter(IOStatement.class::isInstance).map(IOStatement.class::cast).forEach(statement -> {
            boolean smells;
            Constants.LocalizationKeys.LocalizationEntry smell = statement.labelAccess().roundRobin().getSmell(statement.labelAccess(), statement.each());
            if (smell != null) {
                warnings.add(smell.get(statement.toStringPretty()));
            }
            if (smells = statement.resourceLimits().resourceLimits().stream().anyMatch(rl -> rl.limit().quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND && !rl.resourceId().usesRegex())) {
                warnings.add(Constants.LocalizationKeys.PROGRAM_WARNING_RESOURCE_EACH_WITHOUT_PATTERN.get(statement.toStringPretty()));
            }
        });
        return warnings;
    }

    public void fixWarnings(ItemStack disk, ManagerBlockEntity manager) {
        LabelPositionHolder labels = LabelPositionHolder.from(disk);
        labels.removeIf(label -> !this.referencedLabels.contains(label));
        CableNetworkManager.getOrRegisterNetworkFromManagerPosition(manager).ifPresent(network -> labels.removeIf((label, pos) -> !network.isAdjacentToCable((BlockPos)pos)));
        labels.save(disk);
        DiskItem.setWarnings(disk, this.gatherWarnings(disk, manager));
    }

    public boolean tick(ManagerBlockEntity manager) {
        ProgramContext context = new ProgramContext(this, manager, ProgramContext.ExecutionPolicy.UNRESTRICTED);
        this.tick(context);
        manager.clearRedstonePulseQueue();
        boolean didSomething = this.triggers.stream().anyMatch(t -> t.shouldTick(context));
        return didSomething;
    }

    @Override
    public List<Statement> getStatements() {
        return this.triggers.stream().map(x -> x).toList();
    }

    @Override
    public void tick(ProgramContext context) {
        for (Trigger t : this.triggers) {
            if (!t.shouldTick(context)) continue;
            t.tick(context.copy());
        }
    }

    @Override
    public String toString() {
        StringBuilder rtn = new StringBuilder();
        rtn.append("NAME \"").append(this.name).append("\"\n");
        for (Trigger trigger : this.triggers) {
            rtn.append(trigger).append("\n");
        }
        return rtn.toString();
    }

    public void replaceOutputStatement(OutputStatement oldStatement, OutputStatement newStatement) {
        ArrayDeque<Statement> toPatch = new ArrayDeque<Statement>();
        toPatch.add(this);
        while (!toPatch.isEmpty()) {
            Statement statement = (Statement)toPatch.pollFirst();
            List<Statement> children = statement.getStatements();
            for (int i = 0; i < children.size(); ++i) {
                Statement child = children.get(i);
                if (child == oldStatement) {
                    children.set(i, newStatement);
                    continue;
                }
                toPatch.add(child);
            }
        }
    }

    public int getConditionIndex(IfStatement statement) {
        ArrayDeque<Statement> toVisit = new ArrayDeque<Statement>();
        toVisit.add(this);
        int seen = 0;
        while (!toVisit.isEmpty()) {
            Statement current = (Statement)toVisit.pollFirst();
            if (current instanceof IfStatement) {
                IfStatement ifStatement = (IfStatement)current;
                if (ifStatement == statement) {
                    return seen;
                }
                ++seen;
            }
            toVisit.addAll(current.getStatements());
        }
        return -1;
    }

    public int getConditionCount() {
        ArrayDeque<Statement> toVisit = new ArrayDeque<Statement>();
        toVisit.add(this);
        int seen = 0;
        while (!toVisit.isEmpty()) {
            Statement current = (Statement)toVisit.pollFirst();
            if (current instanceof IfStatement) {
                ++seen;
            }
            toVisit.addAll(current.getStatements());
        }
        return seen;
    }

    public static class ListErrorListener
    extends BaseErrorListener {
        private final List<String> errors;

        public ListErrorListener(List<String> errors) {
            this.errors = errors;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.errors.add("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

