/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;

public class RoundRobin
implements ASTNode {
    private final Behaviour behaviour;
    private int index = 0;

    public RoundRobin(Behaviour behaviour) {
        this.behaviour = behaviour;
    }

    public static RoundRobin disabled() {
        return new RoundRobin(Behaviour.UNMODIFIED);
    }

    @Nullable
    public Constants.LocalizationKeys.LocalizationEntry getSmell(LabelAccess labelAccess, boolean each) {
        if (this.behaviour == Behaviour.BY_BLOCK && each) {
            return Constants.LocalizationKeys.PROGRAM_WARNING_ROUND_ROBIN_SMELLY_EACH;
        }
        if (this.behaviour == Behaviour.BY_LABEL && labelAccess.labels().size() == 1) {
            return Constants.LocalizationKeys.PROGRAM_WARNING_ROUND_ROBIN_SMELLY_COUNT;
        }
        return null;
    }

    public Stream<BlockPos> gather(LabelAccess labelAccess, LabelPositionHolder labelPositions) {
        return switch (this.behaviour) {
            default -> throw new IncompatibleClassChangeError();
            case Behaviour.BY_LABEL -> {
                int index = this.next(labelAccess.labels().size());
                yield labelPositions.getPositions(labelAccess.labels().get(index).name()).stream();
            }
            case Behaviour.BY_BLOCK -> {
                List positions = labelAccess.labels().stream().map(Label::name).map(labelPositions::getPositions).flatMap(Collection::stream).distinct().toList();
                if (positions.isEmpty()) {
                    yield Stream.empty();
                }
                yield Stream.of((BlockPos)positions.get(this.next(positions.size())));
            }
            case Behaviour.UNMODIFIED -> labelAccess.labels().stream().map(Label::name).map(labelPositions::getPositions).flatMap(Collection::stream);
        };
    }

    public int next(int max) {
        return this.index++ % max;
    }

    public String toString() {
        return switch (this.behaviour) {
            default -> throw new IncompatibleClassChangeError();
            case Behaviour.UNMODIFIED -> "NOT ROUND ROBIN";
            case Behaviour.BY_BLOCK -> "ROUND ROBIN BY BLOCK";
            case Behaviour.BY_LABEL -> "ROUND ROBIN BY LABEL";
        };
    }

    public boolean isEnabled() {
        return this.behaviour != Behaviour.UNMODIFIED;
    }

    public static enum Behaviour {
        UNMODIFIED,
        BY_BLOCK,
        BY_LABEL;

    }
}

