/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.blue.endless.jankson.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.Comment;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.JsonArray;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.JsonElement;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.JsonNull;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.JsonObject;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.JsonPrimitive;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.annotation.SerializedName;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.annotation.Serializer;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.api.DeserializationException;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.api.DeserializerFunction;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.api.Marshaller;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.impl.POJODeserializer;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.impl.serializer.DeserializerFunctionPool;
import net.creeperhost.ftbbackups.repack.blue.endless.jankson.magic.TypeMagic;

@Deprecated
public class MarshallerImpl
implements Marshaller {
    private static MarshallerImpl INSTANCE = new MarshallerImpl();
    private Map<Class<?>, Function<Object, ?>> primitiveMarshallers = new HashMap();
    Map<Class<?>, Function<JsonObject, ?>> typeAdapters = new HashMap();
    private Map<Class<?>, BiFunction<Object, Marshaller, JsonElement>> serializers = new HashMap();
    private Map<Class<?>, DeserializerFunctionPool<?>> deserializers = new HashMap();
    private Map<Class<?>, Supplier<?>> typeFactories = new HashMap();

    public static Marshaller getFallback() {
        return INSTANCE;
    }

    public <T> void register(Class<T> clazz, Function<Object, T> marshaller) {
        this.primitiveMarshallers.put(clazz, marshaller);
    }

    public <T> void registerTypeAdapter(Class<T> clazz, Function<JsonObject, T> adapter) {
        this.typeAdapters.put(clazz, adapter);
    }

    public <T> void registerSerializer(Class<T> clazz, Function<T, JsonElement> serializer) {
        this.serializers.put(clazz, (it, marshaller) -> (JsonElement)serializer.apply(it));
    }

    public <T> void registerSerializer(Class<T> clazz, BiFunction<T, Marshaller, JsonElement> serializer) {
        this.serializers.put(clazz, serializer);
    }

    public <T> void registerTypeFactory(Class<T> clazz, Supplier<T> supplier) {
        this.typeFactories.put(clazz, supplier);
    }

    public <A, B> void registerDeserializer(Class<A> sourceClass, Class<B> targetClass, DeserializerFunction<A, B> function) {
        DeserializerFunctionPool<Object> pool = this.deserializers.get(targetClass);
        if (pool == null) {
            pool = new DeserializerFunctionPool<B>(targetClass);
            this.deserializers.put(targetClass, pool);
        }
        pool.registerUnsafe(sourceClass, function);
    }

    public MarshallerImpl() {
        this.register(Void.class, it -> null);
        this.register(String.class, it -> it.toString());
        this.register(Byte.class, it -> it instanceof Number ? Byte.valueOf(((Number)it).byteValue()) : null);
        this.register(Character.class, it -> Character.valueOf(it instanceof Number ? (char)((Number)it).shortValue() : it.toString().charAt(0)));
        this.register(Short.class, it -> it instanceof Number ? Short.valueOf(((Number)it).shortValue()) : null);
        this.register(Integer.class, it -> it instanceof Number ? Integer.valueOf(((Number)it).intValue()) : null);
        this.register(Long.class, it -> it instanceof Number ? Long.valueOf(((Number)it).longValue()) : null);
        this.register(Float.class, it -> it instanceof Number ? Float.valueOf(((Number)it).floatValue()) : null);
        this.register(Double.class, it -> it instanceof Number ? Double.valueOf(((Number)it).doubleValue()) : null);
        this.register(Boolean.class, it -> it instanceof Boolean ? (Boolean)it : null);
        this.register(Void.TYPE, it -> null);
        this.register(Byte.TYPE, it -> it instanceof Number ? Byte.valueOf(((Number)it).byteValue()) : null);
        this.register(Character.TYPE, it -> Character.valueOf(it instanceof Number ? (char)((Number)it).shortValue() : it.toString().charAt(0)));
        this.register(Short.TYPE, it -> it instanceof Number ? Short.valueOf(((Number)it).shortValue()) : null);
        this.register(Integer.TYPE, it -> it instanceof Number ? Integer.valueOf(((Number)it).intValue()) : null);
        this.register(Long.TYPE, it -> it instanceof Number ? Long.valueOf(((Number)it).longValue()) : null);
        this.register(Float.TYPE, it -> it instanceof Number ? Float.valueOf(((Number)it).floatValue()) : null);
        this.register(Double.TYPE, it -> it instanceof Number ? Double.valueOf(((Number)it).doubleValue()) : null);
        this.register(Boolean.TYPE, it -> it instanceof Boolean ? (Boolean)it : null);
        this.registerSerializer(Void.class, (T it) -> JsonNull.INSTANCE);
        this.registerSerializer(Character.class, (T it) -> new JsonPrimitive("" + it));
        this.registerSerializer(String.class, JsonPrimitive::new);
        this.registerSerializer(Byte.class, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Short.class, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Integer.class, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Long.class, JsonPrimitive::new);
        this.registerSerializer(Float.class, (T it) -> new JsonPrimitive(it.floatValue()));
        this.registerSerializer(Double.class, JsonPrimitive::new);
        this.registerSerializer(Boolean.class, JsonPrimitive::new);
        this.registerSerializer(Void.TYPE, (T it) -> JsonNull.INSTANCE);
        this.registerSerializer(Character.TYPE, (T it) -> new JsonPrimitive("" + it));
        this.registerSerializer(Byte.TYPE, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Short.TYPE, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Integer.TYPE, (T it) -> new JsonPrimitive(it));
        this.registerSerializer(Long.TYPE, JsonPrimitive::new);
        this.registerSerializer(Float.TYPE, (T it) -> new JsonPrimitive(it.floatValue()));
        this.registerSerializer(Double.TYPE, JsonPrimitive::new);
        this.registerSerializer(Boolean.TYPE, JsonPrimitive::new);
    }

    @Nullable
    public <T> T marshall(Type type, JsonElement elem) {
        if (elem == null) {
            return null;
        }
        if (elem == JsonNull.INSTANCE) {
            return null;
        }
        if (type instanceof Class) {
            try {
                return this.marshall((Class<T>)((Class)type), elem);
            }
            catch (ClassCastException t) {
                return null;
            }
        }
        if (type instanceof ParameterizedType) {
            try {
                Class<?> clazz = TypeMagic.classForType(type);
                return (T)this.marshall(clazz, elem);
            }
            catch (ClassCastException t) {
                return null;
            }
        }
        return null;
    }

    public <T> T marshall(Class<T> clazz, JsonElement elem) {
        try {
            return this.marshall(clazz, elem, false);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public <T> T marshallCarefully(Class<T> clazz, JsonElement elem) throws DeserializationException {
        return this.marshall(clazz, elem, true);
    }

    @Nullable
    public <T> T marshall(Class<T> clazz, JsonElement elem, boolean failFast) throws DeserializationException {
        if (elem == null) {
            return null;
        }
        if (elem == JsonNull.INSTANCE) {
            return null;
        }
        if (clazz.isAssignableFrom(elem.getClass())) {
            return (T)elem;
        }
        DeserializerFunctionPool<Object> pool = this.deserializers.get(clazz);
        if (pool != null) {
            try {
                return (T)pool.apply(elem, this);
            }
            catch (DeserializerFunctionPool.FunctionMatchFailedException functionMatchFailedException) {
                // empty catch block
            }
        }
        pool = POJODeserializer.deserializersFor(clazz);
        try {
            Object poolResult = pool.apply(elem, this);
            return (T)poolResult;
        }
        catch (DeserializerFunctionPool.FunctionMatchFailedException functionMatchFailedException) {
            if (Enum.class.isAssignableFrom(clazz)) {
                if (!(elem instanceof JsonPrimitive)) {
                    return null;
                }
                String name = ((JsonPrimitive)elem).getValue().toString();
                T[] constants = clazz.getEnumConstants();
                if (constants == null) {
                    return null;
                }
                for (T t : constants) {
                    if (!((Enum)t).name().equals(name)) continue;
                    return t;
                }
            }
            if (clazz.equals(String.class)) {
                if (elem instanceof JsonObject) {
                    return (T)((JsonObject)elem).toJson(false, false);
                }
                if (elem instanceof JsonArray) {
                    return (T)((JsonArray)elem).toJson(false, false);
                }
                if (elem instanceof JsonPrimitive) {
                    ((JsonPrimitive)elem).getValue();
                    return (T)((JsonPrimitive)elem).asString();
                }
                if (elem instanceof JsonNull) {
                    return (T)"null";
                }
                if (failFast) {
                    throw new DeserializationException("Encountered unexpected JsonElement type while deserializing to string: " + elem.getClass().getCanonicalName());
                }
                return null;
            }
            if (elem instanceof JsonPrimitive) {
                Function<Object, ?> func = this.primitiveMarshallers.get(clazz);
                if (func != null) {
                    return (T)func.apply(((JsonPrimitive)elem).getValue());
                }
                if (failFast) {
                    throw new DeserializationException("Don't know how to unpack value '" + elem.toString() + "' into target type '" + clazz.getCanonicalName() + "'");
                }
                return null;
            }
            if (elem instanceof JsonObject) {
                Object result;
                if (clazz.isPrimitive()) {
                    throw new DeserializationException("Can't marshall json object into primitive type " + clazz.getCanonicalName());
                }
                if (JsonPrimitive.class.isAssignableFrom(clazz)) {
                    if (failFast) {
                        throw new DeserializationException("Can't marshall json object into a json primitive");
                    }
                    return null;
                }
                JsonObject obj = (JsonObject)elem;
                obj.setMarshaller(this);
                if (this.typeAdapters.containsKey(clazz)) {
                    return (T)this.typeAdapters.get(clazz).apply((JsonObject)elem);
                }
                if (this.typeFactories.containsKey(clazz)) {
                    result = this.typeFactories.get(clazz).get();
                    try {
                        POJODeserializer.unpackObject(result, obj, failFast);
                        return result;
                    }
                    catch (Throwable t) {
                        if (failFast) {
                            throw t;
                        }
                        return null;
                    }
                }
                try {
                    result = TypeMagic.createAndCast(clazz, failFast);
                    POJODeserializer.unpackObject(result, obj, failFast);
                    return result;
                }
                catch (Throwable t) {
                    if (failFast) {
                        throw t;
                    }
                    return null;
                }
            }
            if (elem instanceof JsonArray) {
                if (clazz.isPrimitive()) {
                    return null;
                }
                if (clazz.isArray()) {
                    Class<?> componentType = clazz.getComponentType();
                    JsonArray array = (JsonArray)elem;
                    Object result = Array.newInstance(componentType, array.size());
                    for (int i = 0; i < array.size(); ++i) {
                        Array.set(result, i, this.marshall(componentType, array.get(i)));
                    }
                    return (T)result;
                }
            }
            return null;
        }
    }

    @Override
    public JsonElement serialize(Object obj) {
        Comment comment;
        SerializedName nameAnnotation;
        String name;
        Object child2;
        Object result2;
        JsonElement parsed;
        JsonArray array;
        if (obj == null) {
            return JsonNull.INSTANCE;
        }
        BiFunction<Object, Marshaller, JsonElement> serializer = this.serializers.get(obj.getClass());
        if (serializer != null) {
            JsonElement result2 = serializer.apply(obj, this);
            if (result2 instanceof JsonObject) {
                ((JsonObject)result2).setMarshaller(this);
            }
            if (result2 instanceof JsonArray) {
                ((JsonArray)result2).setMarshaller(this);
            }
            return result2;
        }
        for (Map.Entry<Class<?>, BiFunction<Object, Marshaller, JsonElement>> entry : this.serializers.entrySet()) {
            if (!entry.getKey().isAssignableFrom(obj.getClass())) continue;
            JsonElement result3 = entry.getValue().apply(obj, this);
            if (result3 instanceof JsonObject) {
                ((JsonObject)result3).setMarshaller(this);
            }
            if (result3 instanceof JsonArray) {
                ((JsonArray)result3).setMarshaller(this);
            }
            return result3;
        }
        for (Method m : obj.getClass().getDeclaredMethods()) {
            Class<?> clazz;
            if (!m.isAnnotationPresent(Serializer.class) || Modifier.isStatic(m.getModifiers()) || !JsonElement.class.isAssignableFrom(clazz = m.getReturnType())) continue;
            Parameter[] params = m.getParameters();
            if (params.length == 0) {
                try {
                    boolean access = m.isAccessible();
                    if (!access) {
                        m.setAccessible(true);
                    }
                    JsonElement result4 = (JsonElement)m.invoke(obj, new Object[0]);
                    if (!access) {
                        m.setAccessible(false);
                    }
                    if (result4 instanceof JsonObject) {
                        ((JsonObject)result4).setMarshaller(this);
                    }
                    if (result4 instanceof JsonArray) {
                        ((JsonArray)result4).setMarshaller(this);
                    }
                    return result4;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return JsonNull.INSTANCE;
                }
            }
            if (params.length != 1 || !Marshaller.class.isAssignableFrom(params[0].getType())) continue;
            try {
                boolean access = m.isAccessible();
                if (!access) {
                    m.setAccessible(true);
                }
                JsonElement result5 = (JsonElement)m.invoke(obj, this);
                if (!access) {
                    m.setAccessible(false);
                }
                if (result5 instanceof JsonObject) {
                    ((JsonObject)result5).setMarshaller(this);
                }
                if (result5 instanceof JsonArray) {
                    ((JsonArray)result5).setMarshaller(this);
                }
                return result5;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return JsonNull.INSTANCE;
            }
        }
        if (obj instanceof Enum) {
            return new JsonPrimitive(((Enum)obj).name());
        }
        if (obj.getClass().isArray()) {
            array = new JsonArray();
            array.setMarshaller(this);
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Object elem = Array.get(obj, i);
                parsed = this.serialize(elem);
                array.add(parsed);
            }
            return array;
        }
        if (obj instanceof Collection) {
            array = new JsonArray();
            array.setMarshaller(this);
            for (Object elem : (Collection)obj) {
                parsed = this.serialize(elem);
                array.add(parsed);
            }
            return array;
        }
        if (obj instanceof Map) {
            result2 = new JsonObject();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                String k = entry.getKey().toString();
                Object v = entry.getValue();
                ((JsonObject)result2).put(k, this.serialize(v));
            }
            return result2;
        }
        result2 = new JsonObject();
        for (Field f : obj.getClass().getFields()) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                child2 = f.get(obj);
                name = f.getName();
                nameAnnotation = f.getAnnotation(SerializedName.class);
                if (nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                if ((comment = f.getAnnotation(Comment.class)) == null) {
                    ((JsonObject)result2).put(name, this.serialize(child2));
                    continue;
                }
                ((JsonObject)result2).put(name, this.serialize(child2), comment.value());
            }
            catch (IllegalAccessException | IllegalArgumentException child2) {
                // empty catch block
            }
        }
        for (Field f : obj.getClass().getDeclaredFields()) {
            if (Modifier.isPublic(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                child2 = f.get(obj);
                name = f.getName();
                nameAnnotation = f.getAnnotation(SerializedName.class);
                if (nameAnnotation != null) {
                    name = nameAnnotation.value();
                }
                if ((comment = f.getAnnotation(Comment.class)) == null) {
                    ((JsonObject)result2).put(name, this.serialize(child2));
                    continue;
                }
                ((JsonObject)result2).put(name, this.serialize(child2), comment.value());
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return result2;
    }
}

